/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.StateListDialog;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RelatedToStateColumn
extends XViewerAtsAttributeValueColumn {
    public static RelatedToStateColumn instance = new RelatedToStateColumn();
    public static String NONE = "<empty>";
    public static String RELATED_TO_STATE_SELECTION = "State that the task MUST be completed in if set";

    public static RelatedToStateColumn getInstance() {
        return instance;
    }

    private RelatedToStateColumn() {
        super((AttributeTypeToken)AtsAttributeTypes.RelatedToState, "ats.column.relatedToState", AtsAttributeTypes.RelatedToState.getUnqualifiedName(), 80, XViewerAlign.Left, false, SortDataType.String, true, "");
    }

    @Override
    public RelatedToStateColumn copy() {
        RelatedToStateColumn newXCol = new RelatedToStateColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public static boolean promptChangeRelatedToState(AbstractWorkflowArtifact sma) {
        if (sma.isTask()) {
            return RelatedToStateColumn.promptChangeRelatedToState(Arrays.asList((TaskArtifact)sma));
        }
        AWorkbench.popup((String)"Select Tasks to change Related-to-State");
        return false;
    }

    public static boolean promptChangeRelatedToState(Collection<? extends TaskArtifact> tasks) {
        block8: {
            String selectedState;
            block9: {
                if (tasks.isEmpty()) {
                    AWorkbench.popup((String)"Select Tasks to change Related-to-State");
                    return false;
                }
                ArrayList<String> validStates = new ArrayList<String>();
                validStates.add(NONE);
                validStates.addAll(RelatedToStateColumn.getValidInWorkStates(tasks.iterator().next().getParentTeamWorkflow()));
                StateListDialog dialog = new StateListDialog("Change Related-to-State", RELATED_TO_STATE_SELECTION, validStates);
                if (tasks.size() == 1 && Strings.isValid((String)(selectedState = (String)tasks.iterator().next().getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.RelatedToState, "")))) {
                    dialog.setInitialSelections(new Object[]{selectedState});
                }
                if (dialog.open() != 0) break block8;
                selectedState = dialog.getSelectedState();
                if (!selectedState.isEmpty()) break block9;
                AWorkbench.popup((String)"No Related-to-State selected");
                return false;
            }
            try {
                if (selectedState.equals(NONE)) {
                    selectedState = "";
                }
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Change Related-to-State");
                for (TaskArtifact taskArtifact : tasks) {
                    String state = (String)taskArtifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.RelatedToState, "");
                    if (state.equals(selectedState)) continue;
                    if (Strings.isInValid((String)selectedState)) {
                        changes.deleteAttributes((IAtsObject)taskArtifact, (AttributeTypeToken)AtsAttributeTypes.RelatedToState);
                        continue;
                    }
                    changes.setSoleAttributeValue((IAtsWorkItem)taskArtifact, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, selectedState);
                }
                changes.executeIfNeeded();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't change Related-to-State", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public static List<String> getValidInWorkStates(TeamWorkFlowArtifact teamArt) {
        ArrayList<String> names = new ArrayList<String>();
        for (String state : AtsApiService.get().getWorkDefinitionService().getStateNames(teamArt.getWorkDefinition())) {
            if (!teamArt.getStateDefinitionByName(state).getStateType().isWorkingState()) continue;
            names.add(state);
        }
        Collections.sort(names);
        return names;
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            if (Artifacts.isOfType((Object)treeItem.getData(), (ArtifactTypeToken)AtsArtifactTypes.Task)) {
                TaskArtifact taskArt = (TaskArtifact)((Object)treeItem.getData());
                boolean modified = RelatedToStateColumn.promptChangeRelatedToState(taskArt);
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    taskArt.persist("persist related-to-state via alt-left-click");
                }
                if (modified) {
                    xViewer.update((Object)taskArt, null);
                    return true;
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        HashSet<TaskArtifact> tasks = new HashSet<TaskArtifact>();
        for (TreeItem item : treeItems) {
            if (!(item.getData() instanceof Artifact)) continue;
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) continue;
            tasks.add((TaskArtifact)art);
        }
        if (tasks.isEmpty()) {
            AWorkbench.popup((String)"Invalid selection for setting related-to-state.");
            return;
        }
        RelatedToStateColumn.promptChangeRelatedToState(tasks);
    }
}

