/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.api.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class StringDataSource
implements DataSource {
    private final String name;
    private String data;
    private String charset;
    private String contentType;
    private ByteArrayOutputStream outputStream;

    public StringDataSource(String name, String data) {
        this.name = name;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType.toLowerCase();
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null && this.outputStream == null) {
            throw new IOException("No data");
        }
        if (this.outputStream != null) {
            String encodedOut = this.outputStream.toString(this.charset);
            this.data = this.data == null ? encodedOut : this.data.concat(encodedOut);
            this.outputStream = null;
        }
        return new ByteArrayInputStream(this.data.getBytes(this.charset));
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }

    public String getContentType() {
        String toReturn = this.contentType != null && this.contentType.indexOf("charset") > 0 && this.contentType.startsWith("text/") ? this.contentType : String.format("%s; charset=%s", this.contentType != null ? this.contentType : "text/plain", this.charset);
        return toReturn;
    }
}

