/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.OteArtifactTypes;
import org.eclipse.osee.framework.core.enums.OteAttributeTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactPromptChange;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.jobs.CommitTestRunJob;
import org.eclipse.osee.ote.ui.define.utilities.CommitConfiguration;
import org.eclipse.osee.ote.ui.define.viewers.DragDropHandler;
import org.eclipse.osee.ote.ui.define.viewers.IDataChangedListener;
import org.eclipse.osee.ote.ui.define.viewers.TestRunXViewerFactory;
import org.eclipse.osee.ote.ui.define.viewers.XViewerDataManager;
import org.eclipse.osee.ote.ui.define.viewers.actions.AbstractActionHandler;
import org.eclipse.osee.ote.ui.define.viewers.actions.LaunchReportsAction;
import org.eclipse.osee.ote.ui.define.viewers.actions.OpenAssociatedOutfile;
import org.eclipse.osee.ote.ui.define.viewers.actions.OpenAssociatedScript;
import org.eclipse.osee.ote.ui.define.viewers.actions.OpenInArtifactEditor;
import org.eclipse.osee.ote.ui.define.viewers.data.ArtifactItem;
import org.eclipse.osee.ote.ui.define.viewers.data.DataItemContentProvider;
import org.eclipse.osee.ote.ui.define.viewers.data.DataItemLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TestRunXViewer
extends XViewer {
    private static final ImageDescriptor COMMIT_IMAGE = ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.COMMIT);
    private static final ImageDescriptor REMOVE_IMAGE = ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.REMOVE);
    private static final ImageDescriptor REMOVE_ALL_IMAGE = ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.REMOVE_ALL);
    private XViewerDataManager dataManager;
    private final List<AbstractActionHandler> actionList = new ArrayList<AbstractActionHandler>();
    private Action editDisposition;

    public TestRunXViewer(Composite parent) {
        super(parent, 67586, (IXViewerFactory)new TestRunXViewerFactory());
        this.setSorter(null);
        this.setContentProvider((IContentProvider)new DataItemContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DataItemLabelProvider(this));
        this.setUseHashlookup(true);
        this.setupActions();
        this.getMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestRunXViewer.this.customActions();
            }
        });
    }

    private void customActions() {
        MenuManager manager = this.getMenuManager();
        manager.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editDisposition);
        manager.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        int index = 0;
        while (index < this.actionList.size()) {
            Action action = this.actionList.get(index);
            if (index + 1 >= this.actionList.size() || index + 2 >= this.actionList.size() || index == 3) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)action);
            ++index;
        }
    }

    protected void createSupportWidgets(Composite parent) {
        super.createSupportWidgets(parent);
        this.dataManager = new XViewerDataManager(this);
        new DragDropHandler(this.dataManager);
    }

    public void registerListener(IDataChangedListener listener) {
        this.dataManager.registerListener(listener);
    }

    public void deRegisterListener(IDataChangedListener listener) {
        this.dataManager.deRegisterListener(listener);
    }

    private void setupActions() {
        try {
            this.editDisposition = new Action("Edit Disposition", 1){

                public void run() {
                    try {
                        TestRunXViewer.this.handleChangeDisposition();
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            };
            this.actionList.add(new OpenInArtifactEditor((StructuredViewer)this, "Open as Artifact"));
            this.actionList.add(new OpenAssociatedOutfile((StructuredViewer)this, "Open Outfile"));
            this.actionList.add(new OpenAssociatedScript((StructuredViewer)this, "Open Script"));
            this.actionList.add(new RemoveAction("Remove", REMOVE_IMAGE));
            this.actionList.add(new RemoveAllAction("Remove All", REMOVE_ALL_IMAGE));
            this.actionList.add(new LaunchReportsAction((StructuredViewer)this, "Reports..."));
            this.actionList.add(new CommitAction("Commit Test Runs...", COMMIT_IMAGE));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void refresh() {
        super.refresh();
        try {
            if (this.getTree() == null || this.getTree().isDisposed() || this.actionList == null) {
                return;
            }
            for (AbstractActionHandler action : this.actionList) {
                action.updateState();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public boolean handleChangeDisposition() {
        if (!this.getSelectedArtifacts().isEmpty()) {
            return this.setDisposition(this.getSelectedArtifacts());
        }
        return false;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        XViewerColumn xCol = (XViewerColumn)treeColumn.getData();
        Object holder = treeItem.getData();
        boolean returnValue = false;
        if (holder instanceof ArtifactItem && xCol.equals((Object)TestRunXViewerFactory.DISPOSITION)) {
            ArrayList<Artifact> list = new ArrayList<Artifact>();
            list.add(((ArtifactItem)holder).getData());
            try {
                returnValue = this.setDisposition(list);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return returnValue;
    }

    private boolean setDisposition(ArrayList<Artifact> selectedArtifacts) {
        boolean returnValue = false;
        ArrayList<Artifact> dispositionArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : selectedArtifacts) {
            String name;
            if (!artifact.isOfType(new ArtifactTypeId[]{OteArtifactTypes.TestRun}) || (name = artifact.getName()).equals("Unnamed")) continue;
            Artifact dispoArtifact = null;
            try {
                dispoArtifact = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)OteArtifactTypes.TestRunDisposition, (String)name, (BranchId)artifact.getBranch());
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {
                dispoArtifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)OteArtifactTypes.TestRunDisposition, (BranchToken)artifact.getBranch());
                dispoArtifact.setName(name);
            }
            if (dispoArtifact == null) continue;
            dispositionArtifacts.add(dispoArtifact);
        }
        try {
            returnValue = ArtifactPromptChange.promptChangeAttribute((AttributeTypeToken)OteAttributeTypes.TestDisposition, dispositionArtifacts, (boolean)true, (boolean)false);
            this.refresh();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return returnValue;
    }

    public ArrayList<Artifact> getSelectedArtifacts() {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof ArtifactItem) {
                    arts.add(((ArtifactItem)item.getData()).getData());
                }
                ++n2;
            }
        }
        return arts;
    }

    private final class CommitAction
    extends AbstractActionHandler {
        public CommitAction(String text, ImageDescriptor image) throws Exception {
            super((StructuredViewer)TestRunXViewer.this, text, image);
        }

        public void run() {
            Artifact[] preSelected = TestRunXViewer.this.dataManager.getSelectedForCommit();
            Artifact[] unSelectable = TestRunXViewer.this.dataManager.getUnCommitable();
            CommitTestRunJob job = new CommitTestRunJob(this.getAllItemsList(), preSelected, unSelectable, this.isOverrideAllowed());
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Artifact[] committed = ((CommitTestRunJob)event.getJob()).getCommitted();
                    TestRunXViewer.this.dataManager.removeFromCommitable(Arrays.asList(committed));
                }
            });
            job.schedule();
        }

        @Override
        public void updateState() {
            boolean haveUnCommitableItems = TestRunXViewer.this.dataManager.getUnCommitable().length > 0;
            boolean haveCommitableItems = TestRunXViewer.this.dataManager.getAllCommitable().length > 0;
            this.setEnabled(haveCommitableItems || CommitConfiguration.isCommitOverrideAllowed() && haveUnCommitableItems);
        }

        private boolean isOverrideAllowed() {
            return CommitConfiguration.isCommitOverrideAllowed();
        }

        private Artifact[] getAllItemsList() {
            ArrayList<Artifact> allItems = new ArrayList<Artifact>();
            allItems.addAll(Arrays.asList(TestRunXViewer.this.dataManager.getAllCommitable()));
            if (this.isOverrideAllowed()) {
                allItems.addAll(Arrays.asList(TestRunXViewer.this.dataManager.getUnCommitable()));
            }
            return allItems.toArray(new Artifact[allItems.size()]);
        }
    }

    private final class RemoveAction
    extends AbstractActionHandler {
        public RemoveAction(String text, ImageDescriptor image) throws Exception {
            super((StructuredViewer)TestRunXViewer.this, text, image);
        }

        public void run() {
            TestRunXViewer.this.dataManager.removeSelected();
        }

        @Override
        public void updateState() {
            this.setEnabled(!TestRunXViewer.this.getSelection().isEmpty());
        }
    }

    private final class RemoveAllAction
    extends AbstractActionHandler {
        public RemoveAllAction(String text, ImageDescriptor image) throws Exception {
            super((StructuredViewer)TestRunXViewer.this, text, image);
        }

        public void run() {
            TestRunXViewer.this.dataManager.removeAll();
        }

        @Override
        public void updateState() {
            this.setEnabled(!TestRunXViewer.this.dataManager.isEmpty());
        }
    }
}

