/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.core.client.server.HttpGetMethod;
import org.eclipse.osee.framework.core.client.server.HttpRequest;
import org.eclipse.osee.framework.core.client.server.HttpResourceRequest;
import org.eclipse.osee.framework.core.client.server.HttpResponse;
import org.eclipse.osee.framework.core.client.server.IHttpMethod;
import org.eclipse.osee.framework.logging.OseeLog;

public class HttpRequestHandler
implements Runnable {
    private static Map<HttpRequest.HttpMethod, IHttpMethod> httpMethodHandlers = new HashMap<HttpRequest.HttpMethod, IHttpMethod>();
    private final Socket socket;

    static {
        httpMethodHandlers.put(HttpRequest.HttpMethod.RESOURCE_GET, HttpResourceRequest.getInstance());
        httpMethodHandlers.put(HttpRequest.HttpMethod.GET, new HttpGetMethod());
    }

    public HttpRequestHandler(Socket socket) throws Exception {
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            this.processRequest();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error Processing Request: ", (Throwable)ex);
        }
    }

    private void processRequest() throws Exception {
        HttpRequest httpRequest = null;
        HttpResponse httpResponse = null;
        try {
            httpRequest = new HttpRequest(this.socket);
            httpResponse = new HttpResponse(this.socket);
            try {
                this.processRequest(httpRequest, httpResponse);
            }
            catch (Exception ex) {
                httpResponse.outputStandardError(400, "Exception in processing Request ", ex);
            }
        }
        finally {
            if (httpResponse != null && httpResponse.getOutputStream() != null) {
                httpResponse.getOutputStream().close();
            }
            if (httpRequest != null && httpRequest.getInputStream() != null) {
                httpRequest.getInputStream().close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
    }

    private void processRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        IHttpMethod httpMethod = httpMethodHandlers.get((Object)httpRequest.getMethod());
        if (httpMethod != null) {
            httpMethod.processRequest(httpRequest, httpResponse);
        } else {
            httpResponse.sendResponseHeaders(405, 0L);
        }
    }
}

