/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Arrays;

public class CsvReader {
    private final Reader reader;
    private final StreamTokenizer streamTokenizer;
    private final boolean[] fieldsUsed;
    private int fieldCount;
    private String[] nextRow;

    public CsvReader(File file, int totalNumFields, boolean enabled) throws IOException {
        this(new BufferedReader(new FileReader(file)), totalNumFields, enabled);
    }

    public CsvReader(File file, int totalNumFields) throws IOException {
        this(new BufferedReader(new FileReader(file)), totalNumFields);
    }

    public CsvReader(Reader reader, int totalNumFields) throws IOException {
        this(reader, totalNumFields, true);
    }

    public CsvReader(Reader reader, int totalNumFields, boolean enabled) throws IOException {
        this.reader = reader;
        this.streamTokenizer = new StreamTokenizer(reader);
        this.fieldsUsed = new boolean[totalNumFields];
        Arrays.fill(this.fieldsUsed, enabled);
        this.countFieldsUsed();
        this.streamTokenizer.resetSyntax();
        this.streamTokenizer.eolIsSignificant(true);
        this.streamTokenizer.whitespaceChars(0, 31);
        this.streamTokenizer.wordChars(32, 255);
        this.streamTokenizer.ordinaryChar(44);
        this.streamTokenizer.quoteChar(34);
        this.getRow();
    }

    private void countFieldsUsed() {
        this.fieldCount = 0;
        int i = 0;
        while (i < this.fieldsUsed.length) {
            if (this.fieldsUsed[i]) {
                ++this.fieldCount;
            }
            ++i;
        }
    }

    public void setFieldsEnabled(int start, int end, boolean enable) {
        int i = start;
        while (i <= end) {
            this.setFieldEnabled(i, enable);
            ++i;
        }
    }

    public void setFieldEnabled(int index, boolean enable) {
        this.fieldsUsed[index] = enable;
        this.countFieldsUsed();
    }

    public String[] getRow() throws IOException {
        String[] rowToReturn = this.nextRow;
        this.nextRow = this.getRowInternal();
        return rowToReturn;
    }

    public boolean hasNext() {
        return this.nextRow != null;
    }

    public void skipHeaderRow() throws IOException {
        this.getRow();
    }

    private String[] getRowInternal() throws IOException {
        String[] values = new String[this.fieldCount];
        int fieldIndex = 0;
        int valuesIndex = 0;
        boolean hasValueBeenRead = false;
        while (this.streamTokenizer.nextToken() != 10) {
            if (this.streamTokenizer.ttype == 44) {
                if (this.fieldsUsed[fieldIndex]) {
                    ++valuesIndex;
                }
                ++fieldIndex;
                continue;
            }
            if (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34) {
                if (!this.fieldsUsed[fieldIndex]) continue;
                values[valuesIndex] = this.streamTokenizer.sval;
                hasValueBeenRead = true;
                continue;
            }
            if (this.streamTokenizer.ttype == -1) {
                if (hasValueBeenRead) {
                    return values;
                }
                return null;
            }
            throw new IllegalArgumentException("The token type was: " + this.streamTokenizer.ttype);
        }
        return values;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

