/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.access.AccessControlArtifactUtil;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTransactionData;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTransactionData;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationTransactionData;
import org.eclipse.osee.framework.skynet.core.transaction.BaseTransactionData;
import org.eclipse.osee.framework.skynet.core.transaction.StoreSkynetTransactionOperation;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionOperation;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitor;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitorImpl;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;

public final class SkynetTransaction
extends TransactionOperation<BranchId> {
    private static final String ATTR_ID_SEQ = "SKYNET_ATTR_ID_SEQ";
    private static final String REL_LINK_ID_SEQ = "SKYNET_REL_LINK_ID_SEQ";
    private final CompositeKeyHashMap<Class<? extends BaseTransactionData>, Id, BaseTransactionData> transactionDataItems = new CompositeKeyHashMap();
    private final Set<Artifact> modifiedArtifacts = new HashSet<Artifact>();
    private final Set<Artifact> alreadyProcessedArtifacts = new HashSet<Artifact>();
    private String comment;
    private User user;
    private TransactionRecord transaction;
    private static boolean overrideAccess;

    protected SkynetTransaction(TxMonitor<BranchId> txMonitor, BranchId branch, String comment) {
        super(txMonitor, branch, comment);
        this.comment = comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private AttributeId getNewAttributeId(Artifact artifact, Attribute<?> attribute) {
        return AttributeId.valueOf((Long)ConnectionHandler.getNextSequence(ATTR_ID_SEQ, true));
    }

    private int getNewRelationId() {
        return (int)ConnectionHandler.getNextSequence(REL_LINK_ID_SEQ, true);
    }

    private User getAuthor() {
        if (this.user == null) {
            this.user = UserManager.getUser();
        }
        return this.user;
    }

    private void checkAccess(Artifact artifact) {
        if (UserManager.duringMainUserCreation()) {
            return;
        }
        BranchId txBranch = this.getBranch();
        if (!artifact.isOnBranch(txBranch)) {
            Branch branch = BranchManager.getBranch((BranchId)artifact.getBranch());
            String msg = this.getCheckAccessError(artifact, txBranch, (BranchToken)branch);
            throw new OseeStateException(msg, new Object[0]);
        }
        if (!SkynetTransaction.isOverrideAccess()) {
            XResultData rd;
            for (Attribute<?> attr : artifact.getAttributes()) {
                if (!attr.isDirty() || !(rd = ServiceUtil.getOseeClient().getAccessControlService().hasAttributeTypePermission(Collections.singleton(artifact), attr.getAttributeType(), PermissionEnum.WRITE, AccessControlArtifactUtil.getXResultAccessHeader("Skynet Transaction: " + this.comment, artifact))).isErrors()) continue;
                throw new OseeCoreException(rd.toString(), new Object[0]);
            }
            for (RelationLink rel : artifact.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
                if (!rel.isDirty() || !(rd = ServiceUtil.getOseeClient().getAccessControlService().hasRelationTypePermission((ArtifactToken)artifact, rel.getRelationType(), Collections.emptyList(), PermissionEnum.WRITE, AccessControlArtifactUtil.getXResultAccessHeader("Skynet Transaction: " + this.comment, artifact))).isErrors()) continue;
                throw new OseeCoreException(rd.toString(), new Object[0]);
            }
        }
        this.checkNotHistorical(artifact);
    }

    public String getCheckAccessError(ArtifactToken artifact, BranchId txBranch, BranchToken branch) {
        String msg = String.format("The artifact\n\n%s\n\nis on branch\n\n%s\n\nbut this transaction is for branch\n\n%s\n\n", artifact.getGuid(), branch.toStringWithId(), txBranch);
        return msg;
    }

    private void checkNotHistorical(Artifact artifact) {
        if (artifact.isHistorical()) {
            String msg = this.getCheckNotHistoricalError(artifact);
            throw new OseeStateException(msg, new Object[0]);
        }
    }

    public String getCheckNotHistoricalError(Artifact artifact) {
        String msg = String.format("The artifact\n\n%s\n\nmust be at the head of the branch to be edited.", artifact.getGuid());
        return msg;
    }

    private void checkAccess(Artifact artifact, RelationLink link) {
        BranchId txBranch;
        if (UserManager.duringMainUserCreation()) {
            return;
        }
        if (!SkynetTransaction.isOverrideAccess() && !link.isOnBranch(txBranch = this.getBranch())) {
            RelationSide sideToCheck = link.getSide((ArtifactId)artifact).oppositeSide();
            RelationTypeSide relTypeSide = new RelationTypeSide(link.getRelationType(), sideToCheck);
            XResultData rd = ServiceUtil.getOseeClient().getAccessControlService().hasRelationTypePermission((ArtifactToken)artifact, (RelationTypeToken)relTypeSide, null, PermissionEnum.WRITE, AccessControlArtifactUtil.getXResultAccessHeader("Relation Access Denied", Collections.singleton(artifact), relTypeSide));
            if (rd.isErrors()) {
                throw new OseeCoreException(rd.toString(), new Object[0]);
            }
        }
    }

    private Collection<BaseTransactionData> getTransactionData() {
        return this.transactionDataItems.values();
    }

    public Collection<Artifact> getArtifactReferences() {
        return this.modifiedArtifacts;
    }

    @Override
    protected void clear() {
        this.transactionDataItems.clear();
        this.modifiedArtifacts.clear();
        this.alreadyProcessedArtifacts.clear();
    }

    public BranchId getBranch() {
        return (BranchId)this.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifact(Artifact artifact) {
        TxMonitor txMonitor = this.getTxMonitor();
        synchronized (txMonitor) {
            this.addArtifact(artifact, true);
        }
    }

    private void addArtifact(Artifact artifact, boolean force) {
        if (artifact != null) {
            this.ensureCanBeAdded((Object)artifact);
            boolean wasAdded = this.alreadyProcessedArtifacts.add(artifact);
            if (wasAdded || force) {
                this.addArtifactAndAttributes(artifact);
                this.addRelations(artifact);
            }
        }
    }

    private void addArtifactAndAttributes(Artifact artifact) {
        if (artifact.hasDirtyAttributes() || artifact.hasDirtyArtifactType() || artifact.getModType() == ModificationType.REPLACED_WITH_VERSION || artifact.isUseBackingdata()) {
            if (artifact.isDeleted() && !artifact.isInDb()) {
                for (Attribute<?> attribute : artifact.internalGetAttributes()) {
                    if (!attribute.isDirty()) continue;
                    attribute.setNotDirty();
                }
                return;
            }
            if (!SkynetTransaction.isOverrideAccess()) {
                this.checkAccess(artifact);
            }
            this.setTxState(TxMonitorImpl.TxState.MODIFIED);
            if (!artifact.isInDb() || artifact.hasDirtyArtifactType() || artifact.getModType().isDeleted() || artifact.getModType() == ModificationType.REPLACED_WITH_VERSION || artifact.isUseBackingdata()) {
                BaseTransactionData txItem = (BaseTransactionData)this.transactionDataItems.get(ArtifactTransactionData.class, (Object)artifact);
                if (txItem == null) {
                    this.modifiedArtifacts.add(artifact);
                    txItem = new ArtifactTransactionData(artifact);
                    this.transactionDataItems.put(ArtifactTransactionData.class, (Object)artifact, (Object)txItem);
                } else {
                    this.updateTxItem(txItem, artifact.getModType());
                }
            }
            for (Attribute<?> attribute : artifact.internalGetAttributes()) {
                if (!attribute.isDirty()) continue;
                this.modifiedArtifacts.add(artifact);
                this.addAttribute(artifact, attribute);
            }
        }
    }

    private void checkMultiplicity(Artifact artifact, Attribute<?> attr) {
        AttributeTypeToken attributeType = attr.getAttributeType();
        if (attr.getArtifact().getArtifactType().getMax(attributeType) == 1 && artifact.getAttributeCount((AttributeTypeId)attributeType) > 1) {
            throw new OseeStateException("Artifact %s can only have 1 [%s] attribute but has %d", new Object[]{artifact.toStringWithId(), attr.getAttributeType().getName(), artifact.getAttributeCount((AttributeTypeId)attr.getAttributeType())});
        }
    }

    private void checkMultiplicity(Artifact art, RelationLink link) {
        int count;
        int limitToCheck;
        RelationTypeToken relationType = link.getRelationType();
        RelationTypeMultiplicity multiplicity = relationType.getMultiplicity();
        RelationSide sideToCheck = link.getOppositeSide((ArtifactId)art);
        int n = limitToCheck = sideToCheck.isSideA() ? multiplicity.getSideALimit() : multiplicity.getSideBLimit();
        if (limitToCheck == 1 && (count = art.getRelatedArtifactsCount(RelationTypeSide.create((RelationTypeToken)relationType, (RelationSide)sideToCheck))) > 1) {
            throw new OseeStateException("Artifact %s can only have 1 [%s] on [%s] but has %d", new Object[]{art.toStringWithId(), relationType.getSideName(sideToCheck), sideToCheck.name(), count});
        }
    }

    private void addAttribute(Artifact artifact, Attribute<?> attribute) {
        BaseTransactionData txItem;
        if (attribute.isDeleted() && !attribute.isInDb()) {
            return;
        }
        this.checkMultiplicity(artifact, attribute);
        if (attribute.isInvalid()) {
            attribute.internalSetAttributeId(this.getNewAttributeId(artifact, attribute));
        }
        if ((txItem = (BaseTransactionData)this.transactionDataItems.get(AttributeTransactionData.class, attribute)) == null) {
            txItem = new AttributeTransactionData(attribute);
            this.transactionDataItems.put(AttributeTransactionData.class, attribute, (Object)txItem);
        } else {
            this.updateTxItem(txItem, attribute.getModificationType());
        }
    }

    private void addRelations(Artifact artifact) {
        List<RelationLink> links = artifact.getRelationsAll(DeletionFlag.INCLUDE_DELETED);
        for (RelationLink relation : links) {
            if (!relation.isDirty()) continue;
            this.addRelation(artifact, relation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelation(Artifact artifact, RelationLink link) {
        TxMonitor txMonitor = this.getTxMonitor();
        synchronized (txMonitor) {
            RelationEventType relationEventType;
            ModificationType modificationType;
            if (!SkynetTransaction.isOverrideAccess()) {
                this.checkAccess(artifact, link);
            }
            this.setTxState(TxMonitorImpl.TxState.MODIFIED);
            link.setNotDirty();
            Artifact aArtifact = ArtifactQuery.getArtifactFromToken(link.getArtifactIdA(), DeletionFlag.INCLUDE_DELETED);
            Artifact bArtifact = ArtifactQuery.getArtifactFromToken(link.getArtifactIdB(), DeletionFlag.INCLUDE_DELETED);
            if (link.isInDb()) {
                if (link.isUnDeleted()) {
                    modificationType = ModificationType.MODIFIED;
                    relationEventType = RelationEventType.Undeleted;
                } else if (link.isDeleted()) {
                    if (aArtifact != null && aArtifact.isDeleted() || bArtifact != null && bArtifact.isDeleted()) {
                        modificationType = ModificationType.ARTIFACT_DELETED;
                        relationEventType = RelationEventType.Deleted;
                    } else {
                        modificationType = ModificationType.DELETED;
                        relationEventType = RelationEventType.Deleted;
                    }
                } else {
                    modificationType = link.isUseBackingData() || link.getModificationType().matches(new Id[]{ModificationType.REPLACED_WITH_VERSION, ModificationType.INTRODUCED}) ? link.getModificationType() : ModificationType.MODIFIED;
                    relationEventType = RelationEventType.ModifiedRationale;
                }
            } else {
                if (link.isDeleted()) {
                    return;
                }
                this.checkMultiplicity(artifact, link);
                link.internalSetRelationId(this.getNewRelationId());
                modificationType = ModificationType.NEW;
                relationEventType = RelationEventType.Added;
            }
            this.addArtifact(aArtifact, false);
            this.addArtifact(bArtifact, false);
            Id relId = Id.valueOf((Long)link.getId());
            BaseTransactionData txItem = (BaseTransactionData)this.transactionDataItems.get(RelationTransactionData.class, (Object)relId);
            if (txItem == null) {
                txItem = new RelationTransactionData(link, modificationType, relationEventType);
                this.transactionDataItems.put(RelationTransactionData.class, (Object)relId, (Object)txItem);
                if (aArtifact != null) {
                    this.modifiedArtifacts.add(aArtifact);
                }
                if (bArtifact != null) {
                    this.modifiedArtifacts.add(bArtifact);
                }
            } else {
                this.updateTxItem(txItem, modificationType);
            }
        }
    }

    private void updateTxItem(BaseTransactionData itemToCheck, ModificationType currentModType) {
        if (itemToCheck.getModificationType() == ModificationType.NEW && currentModType.isDeleted()) {
            this.transactionDataItems.removeAndGet(itemToCheck.getClass(), (Object)itemToCheck.getItemId());
        } else {
            itemToCheck.setModificationType(currentModType);
        }
    }

    private IOperation createStorageOp() {
        this.transaction = SkynetTransaction.internalCreateTransaction(this.getBranch(), this.getAuthor(), this.comment);
        return new StoreSkynetTransactionOperation(this.getName(), this.getBranch(), this.transaction, this.getTransactionData(), this.getArtifactReferences());
    }

    public static synchronized TransactionRecord internalCreateTransaction(BranchId branch, User userToBlame, String comment) {
        if (comment == null) {
            comment = "";
        }
        TransactionDetailsType txType = TransactionDetailsType.NonBaselined;
        Timestamp timestamp = GlobalTime.GreenwichMeanTimestamp();
        Long txId = ConnectionHandler.getNextSequence("SKYNET_TRANSACTION_ID_SEQ", false);
        return new TransactionRecord(txId, branch, comment, (Date)timestamp, (UserId)userToBlame, ArtifactId.SENTINEL, txType, OseeCodeVersion.getVersionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsItem(Object object) {
        TxMonitor txMonitor = this.getTxMonitor();
        synchronized (txMonitor) {
            return this.modifiedArtifacts.contains(object);
        }
    }

    @Override
    protected void txWork(IProgressMonitor monitor) throws Exception {
        IOperation subOp = this.createStorageOp();
        this.doSubWork(subOp, monitor, 1.0);
    }

    public String toString() {
        return String.format("uuid:[%s] branch[%s] comment[%s]", this.getUuid(), this.getBranch(), this.comment);
    }

    public TransactionToken execute() {
        Operations.executeWorkAndCheckStatus((IOperation)this);
        return this.transaction;
    }

    public void cancel() {
        this.getTxMonitor().cancel(this.getBranch(), this);
    }

    public static boolean isOverrideAccess() {
        return overrideAccess;
    }

    public static void setOverrideAccess(boolean overrideAccess) {
        if (!OseeProperties.isInTest()) {
            throw new OseeArgumentException("Access Control can not be overridden in production", new Object[0]);
        }
        SkynetTransaction.overrideAccess = overrideAccess;
    }
}

