/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event;

import java.util.logging.Level;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionListener;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.skynet.core.event.EventSystemPreferences;
import org.eclipse.osee.framework.skynet.core.event.model.RemoteEventServiceEventType;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;

public final class ConnectionListenerImpl
implements ConnectionListener {
    private final EventSystemPreferences preferences;
    private final Transport transport;

    public ConnectionListenerImpl(EventSystemPreferences preferences, Transport transport) {
        this.preferences = preferences;
        this.transport = transport;
    }

    public void connected(ConnectionNode node) {
        this.transport.setConnected(this.preferences.isOseeEventBrokerValid());
        try {
            this.transport.send(this, RemoteEventServiceEventType.Rem_Connected);
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)"Remote Event Service - Connected");
        }
        catch (OseeCoreException ex) {
            EventUtil.eventLog((String)"REM: ResConnectionListener", (Throwable)ex);
        }
    }

    public void notConnected(ConnectionNode node) {
        this.transport.setConnected(false);
        try {
            this.transport.send(this, RemoteEventServiceEventType.Rem_DisConnected);
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)"Remote Event Service - Dis-Connected");
        }
        catch (OseeCoreException ex) {
            EventUtil.eventLog((String)"REM: ResConnectionListener", (Throwable)ex);
        }
    }
}

