/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.resolvers;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.AttributeBasedArtifactResolver;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IRoughArtifactTranslator;

public class DropTargetAttributeBasedResolver
extends AttributeBasedArtifactResolver {
    private final Artifact dropTarget;

    public DropTargetAttributeBasedResolver(IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, Collection<AttributeTypeToken> nonChangingAttributes, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts, Artifact dropTarget) {
        super(translator, primaryArtifactType, secondaryArtifactType, nonChangingAttributes, createNewIfNotExist, deleteUnmatchedArtifacts);
        this.dropTarget = dropTarget;
    }

    @Override
    public Artifact resolve(RoughArtifact roughArtifact, BranchToken branch, Artifact realParent, Artifact root) {
        if (this.dropTarget != null) {
            String nameToCheck = this.dropTarget.getSafeName();
            if (!roughArtifact.getName().startsWith(nameToCheck)) {
                throw new OseeCoreException("Import name not matched", new Object[0]);
            }
        } else {
            throw new OseeArgumentException("Null drop target provided", new Object[0]);
        }
        this.getTranslator().translate(roughArtifact, this.dropTarget);
        return this.dropTarget;
    }
}

