/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.utility.AbstractDbTxOperation;
import org.eclipse.osee.framework.skynet.core.utility.Id4JoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;

public class UpdateMergeBranch
extends AbstractDbTxOperation {
    private static final String TX_CURRENT_SETTINGS = "CASE WHEN txs1.mod_type = " + ModificationType.DELETED.getIdString() + " THEN " + TxCurrent.DELETED + " WHEN txs1.mod_type = " + ModificationType.ARTIFACT_DELETED.getIdString() + " THEN " + TxCurrent.ARTIFACT_DELETED + " ELSE " + TxCurrent.CURRENT + " END";
    private static final String UPDATE_ARTIFACTS = "INSERT INTO osee_txs (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) SELECT ?, txs1.gamma_id, txs1.mod_type, " + TX_CURRENT_SETTINGS + ", ?, txs1.app_id FROM osee_attribute attr1, osee_txs txs1 WHERE attr1.art_id = ? AND txs1.gamma_id = attr1.gamma_id AND txs1.branch_id = ? AND txs1.tx_current <> ? AND NOT EXISTS (SELECT 'x' FROM osee_txs txs2, osee_attribute attr2 WHERE txs2.branch_id = ? AND txs2.transaction_id = ? AND txs2.gamma_id = attr2.gamma_id AND attr2.attr_id = attr1.attr_id)";
    private static final String PURGE_ATTRIBUTE_FROM_MERGE_BRANCH = "DELETE from osee_txs txs WHERE EXISTS (SELECT 'x' FROM osee_attribute attr WHERE txs.gamma_id = attr.gamma_id AND txs.branch_id = ? AND attr.art_id = ?)";
    private static final String PURGE_RELATION_FROM_MERGE_BRANCH = "DELETE from osee_txs txs WHERE EXISTS (SELECT 'x' FROM osee_relation_link rel WHERE txs.gamma_id = rel.gamma_id AND txs.branch_id = ? AND (rel.a_art_id = ? or rel.b_art_id = ?))";
    private static final String PURGE_ARTIFACT_FROM_MERGE_BRANCH = "DELETE from osee_txs txs WHERE EXISTS (SELECT 'x' FROM osee_artifact art WHERE txs.gamma_id = art.gamma_id AND txs.branch_id = ? AND art.art_id = ?)";
    private static final boolean DEBUG = "TRUE".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.osee.framework.skynet.core/debug/Merge"));
    private final BranchId mergeBranch;
    private final ArrayList<ArtifactId> expectedArtIds;
    private final BranchId destBranch;
    private final BranchId sourceBranch;
    private static final String INSERT_ATTRIBUTE_GAMMAS = "INSERT INTO OSEE_TXS (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) SELECT ?, atr1.gamma_id, txs1.mod_type, ?, ?, txs1.app_id FROM osee_attribute atr1, osee_txs txs1, osee_join_id4 ald1 WHERE txs1.branch_id = ? AND txs1.tx_current in (1,2) AND txs1.gamma_id = atr1.gamma_id AND atr1.art_id = ald1.id2 and ald1.query_id = ?";
    private static final String INSERT_ARTIFACT_GAMMAS = "INSERT INTO OSEE_TXS (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) SELECT ?, arv1.gamma_id, txs1.mod_type, ?, ?, txs1.app_id FROM osee_artifact arv1, osee_txs txs1, osee_join_id4 ald1 WHERE txs1.branch_id = ? AND txs1.tx_current in (1,2) AND txs1.gamma_id = arv1.gamma_id AND arv1.art_id = ald1.id2 and ald1.query_id = ?";

    public UpdateMergeBranch(JdbcClient jdbcClient, BranchId mergeBranch, ArrayList<ArtifactId> expectedArtIds, BranchId destBranch, BranchId sourceBranch) {
        super(jdbcClient, "Update Merge Branch", "org.eclipse.osee.framework.skynet.core");
        this.destBranch = destBranch;
        this.expectedArtIds = expectedArtIds;
        this.mergeBranch = mergeBranch;
        this.sourceBranch = sourceBranch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTxWork(IProgressMonitor monitor, JdbcConnection connection) {
        Collection<ArtifactId> allMergeBranchArtifacts = this.getAllMergeArtifacts(this.mergeBranch);
        long time = System.currentTimeMillis();
        HashSet<ArtifactId> allMergeBranchArtifactsCopy = new HashSet<ArtifactId>(allMergeBranchArtifacts);
        List<Artifact> goodMergeBranchArtifacts = ArtifactQuery.getArtifactListFromBranch(this.mergeBranch, DeletionFlag.INCLUDE_DELETED);
        int count = 0;
        for (Artifact artifact : goodMergeBranchArtifacts) {
            allMergeBranchArtifactsCopy.remove((Object)artifact);
        }
        if (!allMergeBranchArtifactsCopy.isEmpty()) {
            for (ArtifactId artifactId : allMergeBranchArtifactsCopy) {
                this.purgeArtifactFromBranch(connection, this.mergeBranch, artifactId);
                ++count;
            }
        }
        if (DEBUG) {
            System.out.println(String.format("          Deleting %d Damaged Artifacts took %s", count, Lib.getElapseString((long)time)));
            time = System.currentTimeMillis();
            count = 0;
        }
        for (ArtifactId artifactId : this.expectedArtIds) {
            allMergeBranchArtifacts.remove(artifactId);
        }
        if (!allMergeBranchArtifacts.isEmpty()) {
            for (ArtifactId artifactId : allMergeBranchArtifacts) {
                ++count;
                this.purgeArtifactFromBranch(connection, this.mergeBranch, artifactId);
            }
        }
        if (DEBUG) {
            System.out.println(String.format("          Deleting %d unused Artifacts took %s", count, Lib.getElapseString((long)time)));
            time = System.currentTimeMillis();
            count = 0;
        }
        boolean bl = false;
        TransactionRecord baselineTransaction = BranchManager.getBaseTransaction(this.mergeBranch);
        for (Artifact artifact : goodMergeBranchArtifacts) {
            var9_17 += this.getJdbcClient().runPreparedUpdate(connection, UPDATE_ARTIFACTS, new Object[]{baselineTransaction, this.mergeBranch, artifact, this.sourceBranch, TxCurrent.NOT_CURRENT, this.mergeBranch, baselineTransaction});
        }
        if (DEBUG) {
            void var9_17;
            System.out.println(String.format("          Adding %d Attributes to Existing Artifacts took %s", (int)var9_17, Lib.getElapseString((long)time)));
            time = System.currentTimeMillis();
        }
        for (Artifact artifact : goodMergeBranchArtifacts) {
            this.expectedArtIds.remove((Object)artifact);
        }
        if (!this.expectedArtIds.isEmpty()) {
            this.addArtifactsToBranch(connection, this.sourceBranch, this.destBranch, this.mergeBranch, this.expectedArtIds);
        }
        if (DEBUG) {
            System.out.println(String.format("          Adding %d new Artifacts took %s", this.expectedArtIds.size(), Lib.getElapseString((long)time)));
            time = System.currentTimeMillis();
        }
    }

    private void addArtifactsToBranch(JdbcConnection connection, BranchId sourceBranch, BranchId destBranch, BranchId mergeBranch, Collection<ArtifactId> artIds) {
        if (artIds == null || artIds.isEmpty()) {
            throw new IllegalArgumentException("Artifact IDs can not be null or empty");
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery(this.getJdbcClient(), connection);){
                for (ArtifactId artId : artIds) {
                    joinQuery.add((Id)sourceBranch, (Id)artId, (Id)TransactionId.SENTINEL, (Id)sourceBranch.getViewId());
                }
                joinQuery.store();
                TransactionRecord startTx = BranchManager.getBaseTransaction(mergeBranch);
                this.insertGammas(connection, INSERT_ATTRIBUTE_GAMMAS, (TransactionId)startTx, joinQuery.getQueryId(), sourceBranch, mergeBranch);
                this.insertGammas(connection, INSERT_ARTIFACT_GAMMAS, (TransactionId)startTx, joinQuery.getQueryId(), sourceBranch, mergeBranch);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (OseeCoreException oseeCoreException) {
            throw new OseeCoreException("Source Branch %s Artifact Ids: %s", new Object[]{sourceBranch.getId(), Collections.toString((String)",", artIds)});
        }
    }

    private void insertGammas(JdbcConnection connection, String sql, TransactionId baseTx, int queryId, BranchId sourceBranch, BranchId mergeBranch) {
        this.getJdbcClient().runPreparedUpdate(connection, sql, new Object[]{baseTx, TxCurrent.CURRENT, mergeBranch, sourceBranch, queryId});
    }

    private Collection<ArtifactId> getAllMergeArtifacts(BranchId branch) {
        HashSet<ArtifactId> artSet = new HashSet<ArtifactId>();
        this.getJdbcClient().runQuery(stmt -> {
            boolean bl = artSet.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        }, ServiceUtil.getSql(OseeSql.MERGE_GET_ARTIFACTS_FOR_BRANCH), new Object[]{branch});
        this.getJdbcClient().runQuery(stmt -> {
            boolean bl = artSet.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        }, ServiceUtil.getSql(OseeSql.MERGE_GET_ATTRIBUTES_FOR_BRANCH), new Object[]{branch});
        this.getJdbcClient().runQuery(stmt -> {
            artSet.add(ArtifactId.valueOf((Long)stmt.getLong("a_art_id")));
            artSet.add(ArtifactId.valueOf((Long)stmt.getLong("b_art_id")));
        }, ServiceUtil.getSql(OseeSql.MERGE_GET_RELATIONS_FOR_BRANCH), new Object[]{branch});
        return artSet;
    }

    private void purgeArtifactFromBranch(JdbcConnection connection, BranchId branch, ArtifactId artId) {
        this.getJdbcClient().runPreparedUpdate(connection, PURGE_ATTRIBUTE_FROM_MERGE_BRANCH, new Object[]{branch, artId});
        this.getJdbcClient().runPreparedUpdate(connection, PURGE_RELATION_FROM_MERGE_BRANCH, new Object[]{branch, artId, artId});
        this.getJdbcClient().runPreparedUpdate(connection, PURGE_ARTIFACT_FROM_MERGE_BRANCH, new Object[]{branch, artId});
    }
}

