/*********************************************************************
 * Copyright (c) 2004, 2007 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.skynet.core.relation.order;

import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

/**
 * @author Roberto E. Escobar
 */
public class RelationOrderFactory {

   public RelationOrderData createRelationOrderData(Artifact artifact) {
      ArtifactRelationOrderAccessor accessor = new ArtifactRelationOrderAccessor(new RelationOrderParser());
      RelationOrderData data = new RelationOrderData(accessor, artifact);
      data.load();
      return data;
   }
}