/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.PurgeTransactionEventUtil;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.PurgeTransactionOperation;

public class PurgeTransactionOperationWithListener {
    public static IOperation getPurgeTransactionOperation(List<? extends TransactionId> transactions) {
        ArrayList<Long> txIdsToDelete = new ArrayList<Long>();
        for (TransactionId transactionId : transactions) {
            txIdsToDelete.add(transactionId.getId());
        }
        return PurgeTransactionOperationWithListener.getPurgeTransactionOperationById(txIdsToDelete);
    }

    public static IOperation getPurgeTransactionOperation(TransactionId txIdsToDelete) {
        return PurgeTransactionOperationWithListener.getPurgeTransactionOperation(Arrays.asList(txIdsToDelete));
    }

    public static IOperation getPurgeTransactionOperationById(List<Long> txIdsToDelete) {
        ArrayList<TransactionRecord> changedTransactions = new ArrayList<TransactionRecord>();
        for (Long txId : txIdsToDelete) {
            changedTransactions.add(TransactionManager.getTransaction(TransactionId.valueOf((Long)txId)));
        }
        Pair<TransactionEvent, Map<String, Long>> transEventAndIds = PurgeTransactionEventUtil.createPurgeTransactionEvent(changedTransactions);
        final PurgeTransactionOperation op = new PurgeTransactionOperation(txIdsToDelete, transEventAndIds);
        PurgeTransactionOperation.PurgeTransactionListener listener = new PurgeTransactionOperation.PurgeTransactionListener(){

            @Override
            public void onPurgeTransactionSuccess(List<Long> transactions, Pair<TransactionEvent, Map<String, Long>> transEventAndIds) {
                try {
                    OseeEventManager.kickTransactionEvent((Object)op, (TransactionEvent)transEventAndIds.getFirst());
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error sending purge transaction events", (Throwable)ex);
                }
                try {
                    String message = String.format("Purge Transaction [%s] - Guid to Id Map [%s]", ((TransactionEvent)transEventAndIds.getFirst()).toString(), ((Map)transEventAndIds.getSecond()).toString());
                    ServiceUtil.getOseeClient().getActivityLogEndpoint().createEntry((ActivityTypeId)CoreActivityTypes.PURGE_TRANSACTION, Long.valueOf(0L), ActivityLog.COMPLETE_STATUS, message);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error activity logging purge transaction", (Throwable)ex);
                }
            }
        };
        op.addListener(listener);
        return op;
    }
}

