/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcClient;

public class OseeInfo {
    private static final String GET_VALUE_SQL = "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?";
    private static final String INSERT_KEY_VALUE_SQL = "INSERT INTO osee_info (OSEE_KEY, OSEE_VALUE) VALUES (?, ?)";
    private static final String DELETE_KEY_SQL = "DELETE FROM osee_info WHERE OSEE_KEY = ?";
    public static final String SAVE_OUTFILE_IN_DB = "SAVE_OUTFILE_IN_DB";
    public static final String USE_GUID_STORAGE = "osee.framework.skynet.core.guid.storage";
    public static final String DB_ID_KEY = "osee.db.guid";
    public static final String DB_TYPE_KEY = "osee.db.type";
    private static Map<String, Pair<Long, String>> cache = new ConcurrentHashMap<String, Pair<Long, String>>();

    public static String getValue(String key, String defaultValue) {
        return OseeInfo.getValue(ConnectionHandler.getJdbcClient(), key, defaultValue, Integer.MAX_VALUE);
    }

    public static String getValue(String key) {
        return OseeInfo.getValue(key, Integer.MAX_VALUE);
    }

    public static String getValue(String key, Long maxStaleness) {
        return OseeInfo.getValue(ConnectionHandler.getJdbcClient(), key, "", maxStaleness);
    }

    public static String getValue(JdbcClient jdbcClient, String key) {
        return OseeInfo.getValue(jdbcClient, key, "", Integer.MAX_VALUE);
    }

    public static String getValue(JdbcClient jdbcClient, String key, String defaultValue, Long maxStaleness) {
        String value;
        Pair<Long, String> pair = cache.get(key);
        if (pair == null || (Long)pair.getFirst() + maxStaleness < System.currentTimeMillis()) {
            value = (String)jdbcClient.fetch((Object)defaultValue, GET_VALUE_SQL, new Object[]{key});
            OseeInfo.cacheValue(key, value);
        } else {
            value = (String)pair.getSecond();
        }
        return value;
    }

    public static void setValue(String key, String value) {
        ConnectionHandler.runPreparedUpdate(DELETE_KEY_SQL, key);
        ConnectionHandler.runPreparedUpdate(INSERT_KEY_VALUE_SQL, key, value);
        OseeInfo.cacheValue(key, value);
    }

    public static String getDatabaseGuid() {
        return OseeInfo.getValue(DB_ID_KEY);
    }

    public static String getCachedValue(String key) {
        Pair<Long, String> cacheValue = cache.get(key);
        String value = cacheValue == null ? OseeInfo.getValue(ConnectionHandler.getJdbcClient(), key) : (String)cacheValue.getSecond();
        return value;
    }

    private static void cacheValue(String key, String value) {
        Long time = System.currentTimeMillis();
        cache.put(key, (Pair<Long, String>)new Pair((Object)time, (Object)value));
    }
}

