/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleArtifactsExist;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactPersistenceManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationCache;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationTypeSideSorter;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderFactory;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationSorterProvider;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcStatement;

public class RelationManager {
    private static final String GET_DELETED_ARTIFACT = "SELECT DISTINCT %s_art_id, txs.branch_id FROM osee_txs txs, osee_relation_link rel WHERE txs.branch_id = ? AND txs.gamma_id = rel.gamma_id AND rel.rel_link_type_id = ? AND %s_art_id = ? AND txs.tx_current in (2,3)";
    private static final RelationSorterProvider relationSorterProvider = new RelationSorterProvider();
    private static final RelationOrderFactory relationOrderFactory = new RelationOrderFactory();
    private static final RelationCache relationCache = new RelationCache();

    public static void manageRelation(RelationLink newRelation, RelationSide relationSide) {
        Artifact artifact = ArtifactCache.getActive((ArtifactId)newRelation.getArtifactId(relationSide), newRelation.getBranch());
        if (artifact != null) {
            List<RelationLink> artifactsRelations = relationCache.getAll(artifact);
            if (artifactsRelations == null) {
                artifactsRelations = new CopyOnWriteArrayList<RelationLink>();
            }
            for (RelationLink relation : artifactsRelations) {
                if (!relation.getArtifactIdA().equals(newRelation.getArtifactIdA()) || !relation.getArtifactIdB().equals(newRelation.getArtifactIdB()) || !relation.getRelationType().equals(newRelation.getRelationType()) || relation == newRelation) continue;
                OseeLog.logf(Activator.class, (Level)Level.WARNING, (String)"Duplicate relation objects for same relation for RELATION 1 [%s] RELATION 2 [%s]", (Object[])new Object[]{relation, newRelation});
            }
            if (artifactsRelations.contains(newRelation)) {
                return;
            }
            artifactsRelations.add(newRelation);
            relationCache.cache(artifact, newRelation);
        }
    }

    private static List<Artifact> getRelatedArtifactsUnSorted(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        return RelationManager.getRelatedArtifacts(artifact, relationType, relationSide, false);
    }

    public static @NonNull List<Artifact> getRelatedArtifacts(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        return RelationManager.getRelatedArtifacts(artifact, relationType, relationSide, true);
    }

    private static @NonNull List<Artifact> getRelatedArtifacts(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide, boolean sort) {
        ArrayList<Artifact> relatedArtifacts;
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical.  Historical relations are only supported on server", new Object[]{artifact});
        }
        if (relationSide == null) {
            throw new OseeArgumentException("RelationSide cannot be null", new Object[0]);
        }
        List<RelationLink> selectedRelations = null;
        selectedRelations = relationType == null ? relationCache.getAll(artifact) : relationCache.getAllByType(artifact, relationType);
        if (selectedRelations == null) {
            relatedArtifacts = new ArrayList<Artifact>();
        } else {
            relatedArtifacts = new ArrayList(selectedRelations.size());
            ArtifactQuery.getArtifactListFrom(RelationManager.getRelatedArtifactIds(selectedRelations, relationSide, DeletionFlag.EXCLUDE_DELETED), (BranchId)artifact.getBranch());
            for (RelationLink relation : selectedRelations) {
                if (relation.isDeleted()) continue;
                try {
                    if (!relation.getSide((ArtifactId)artifact).isOppositeSide(relationSide)) continue;
                    relationSide = relation.getOppositeSide((ArtifactId)artifact);
                    Artifact relatedArt = relation.getArtifactOnOtherSide((ArtifactId)artifact);
                    if (relatedArt.isDeleted()) continue;
                    relatedArtifacts.add(relatedArt);
                }
                catch (ArtifactDoesNotExist ex) {
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
                }
            }
            if (sort) {
                RelationManager.sort(artifact, relationType, relationSide, relatedArtifacts);
            }
        }
        return relatedArtifacts;
    }

    private static Collection<ArtifactId> getRelatedArtifactIds(List<RelationLink> relations, RelationSide side, DeletionFlag allowDeleted) {
        HashSet<ArtifactId> ret = new HashSet<ArtifactId>();
        if (relations != null) {
            for (RelationLink rel : relations) {
                if (allowDeleted != DeletionFlag.INCLUDE_DELETED && (allowDeleted != DeletionFlag.EXCLUDE_DELETED || rel.isDeleted())) continue;
                ret.add((ArtifactId)rel.getArtifactId(side));
            }
        }
        return ret;
    }

    public static Set<Artifact> getRelatedArtifacts(Collection<? extends Artifact> artifacts, int depth, RelationTypeSide ... relationEnums) {
        return RelationManager.getRelatedArtifacts(artifacts, depth, DeletionFlag.EXCLUDE_DELETED, relationEnums);
    }

    public static Set<Artifact> getRelatedArtifacts(Collection<? extends Artifact> artifacts, int depth, DeletionFlag allowDeleted, RelationTypeSide ... relationEnums) {
        RelationManager.findHistoricalArtifacts(artifacts);
        HashSet<Artifact> relatedArtifacts = new HashSet<Artifact>(artifacts.size() * 8);
        ArrayList<? extends Artifact> newArtifactsToSearch = new ArrayList<Artifact>(artifacts);
        List<Object> newArtifacts = new ArrayList();
        HashSet<ArtifactId> relatedArtIds = new HashSet<ArtifactId>();
        if (artifacts.isEmpty()) {
            return relatedArtifacts;
        }
        int i = 0;
        while (i < depth && !newArtifactsToSearch.isEmpty()) {
            relatedArtIds.clear();
            for (Artifact artifact : newArtifactsToSearch) {
                ArrayList<RelationLink> selectedRelations = new ArrayList<RelationLink>();
                if (relationEnums.length == 0) {
                    List<RelationLink> relations = relationCache.getAll(artifact);
                    for (RelationLink rel : relations) {
                        if (!rel.getArtifactIdA().notEqual((Id)artifact)) continue;
                        selectedRelations.add(rel);
                    }
                    relatedArtIds.addAll(RelationManager.getRelatedArtifactIds(selectedRelations, RelationSide.SIDE_B, allowDeleted));
                    continue;
                }
                RelationTypeSide[] relationTypeSideArray = relationEnums;
                int n = relationEnums.length;
                int n2 = 0;
                while (n2 < n) {
                    RelationTypeSide relationEnum = relationTypeSideArray[n2];
                    List<RelationLink> links = relationCache.getAllByType(artifact, (RelationTypeToken)relationEnum);
                    if (links != null) {
                        for (RelationLink rel : links) {
                            if (!rel.getArtifactId(relationEnum.getSide()).notEqual((Id)artifact)) continue;
                            selectedRelations.add(rel);
                        }
                    }
                    relatedArtIds.addAll(RelationManager.getRelatedArtifactIds(selectedRelations, relationEnum.getSide(), allowDeleted));
                    ++n2;
                }
            }
            if (relatedArtIds.size() > 0) {
                BranchToken branchToken = artifacts.iterator().next().getBranch();
                newArtifacts = ArtifactQuery.getArtifactListFrom(relatedArtIds, (BranchId)branchToken, allowDeleted);
            }
            newArtifactsToSearch.clear();
            newArtifactsToSearch.addAll(newArtifacts);
            relatedArtifacts.addAll(newArtifacts);
            ++i;
        }
        return relatedArtifacts;
    }

    private static void findHistoricalArtifacts(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isHistorical()) continue;
            throw new OseeCoreException("Artifact [%s] is historical. Historical relations are only supported on the server.", new Object[]{artifact});
        }
    }

    public static List<Artifact> getRelatedArtifacts(Artifact artifact, RelationTypeSide relationType, DeletionFlag deletionFlag) {
        List<Artifact> artifacts = RelationManager.getRelatedArtifacts(artifact, (RelationTypeToken)relationType, relationType.getSide());
        ArrayList<ArtifactId> artIds = new ArrayList<ArtifactId>();
        if (deletionFlag.areDeletedAllowed()) {
            Object[] objectArray;
            if (relationType.getSide().isSideA()) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "a";
                objectArray = objectArray2;
                objectArray2[1] = "b";
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = "b";
                objectArray = objectArray3;
                objectArray3[1] = "a";
            }
            Object[] formatArgs = objectArray;
            Throwable throwable = null;
            Object var7_8 = null;
            try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
                String sql = String.format(GET_DELETED_ARTIFACT, formatArgs);
                chStmt.runPreparedQuery(sql, new Object[]{artifact.getBranch(), relationType.getGuid(), artifact});
                while (chStmt.next()) {
                    artIds.add(ArtifactId.valueOf((Long)chStmt.getLong(formatArgs[0] + "_art_id")));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            List<Artifact> deletedArtifacts = ArtifactQuery.getArtifactListFrom(artIds, (BranchId)artifact.getBranch());
            for (Artifact art : deletedArtifacts) {
                if (!art.isDeleted()) continue;
                artifacts.add(art);
            }
        }
        return artifacts;
    }

    public static List<Artifact> getRelatedArtifactsUnSorted(Artifact artifact, RelationTypeSide relationEnum) {
        return RelationManager.getRelatedArtifactsUnSorted(artifact, (RelationTypeToken)relationEnum, relationEnum.getSide());
    }

    public static @NonNull List<Artifact> getRelatedArtifacts(Artifact artifact, RelationTypeSide relationEnum) {
        return RelationManager.getRelatedArtifacts(artifact, (RelationTypeToken)relationEnum, relationEnum.getSide());
    }

    private static Artifact getRelatedArtifact(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        List<Artifact> artifacts = RelationManager.getRelatedArtifactsUnSorted(artifact, relationType, relationSide);
        if (artifacts.isEmpty()) {
            throw new ArtifactDoesNotExist("There is no artifact related to [%s] by a relation of type [%s]", new Object[]{artifact.toStringWithId(), relationType});
        }
        if (artifacts.size() > 1) {
            throw new MultipleArtifactsExist("There are %s artifacts related to \"%s\" by a relation of type \"%s\" on side %s instead of the expected 1.", new Object[]{artifacts.size(), artifact.toStringWithId(), relationType, relationSide});
        }
        return artifacts.get(0);
    }

    public static Artifact getRelatedArtifact(Artifact artifact, RelationTypeSide relationEnum) {
        return RelationManager.getRelatedArtifact(artifact, (RelationTypeToken)relationEnum, relationEnum.getSide());
    }

    public static int getRelatedArtifactsCount(Artifact artifact, RelationTypeSide relationTypeEnum) {
        return RelationManager.getRelatedArtifactsCount(artifact, (RelationTypeToken)relationTypeEnum, relationTypeEnum.getSide());
    }

    public static int getRelatedArtifactsCount(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical.  Historical relations are only supported on server", new Object[]{artifact});
        }
        List<RelationLink> selectedRelations = relationCache.getAllByType(artifact, relationType);
        int artifactCount = 0;
        if (selectedRelations != null) {
            for (RelationLink relation : selectedRelations) {
                if (relation.isDeleted()) continue;
                if (relationSide == null) {
                    ++artifactCount;
                    continue;
                }
                if (relation.getSide((ArtifactId)artifact) == relationSide) continue;
                ++artifactCount;
            }
        }
        return artifactCount;
    }

    public static void prepareRelationsForReload(Artifact artifact) {
        if (!artifact.isHistorical()) {
            relationCache.deCache(artifact);
        }
    }

    public static boolean hasDirtyLinks(Artifact artifact) {
        List<RelationLink> selectedRelations = relationCache.getAll(artifact);
        for (RelationLink relation : selectedRelations) {
            if (!relation.isDirty()) continue;
            return true;
        }
        return false;
    }

    public static String reportHasDirtyLinks(Artifact artifact) {
        List<RelationLink> selectedRelations = relationCache.getAll(artifact);
        if (selectedRelations != null) {
            for (RelationLink relation : selectedRelations) {
                if (!relation.isDirty()) continue;
                try {
                    return String.format("Relation\n\n[%s]\n\naSide [%s]\n\nbSide [%s]", relation, relation.getArtifactIdA(), relation.getArtifactIdB());
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
        return null;
    }

    public static List<RelationLink> getRelationsUnordered(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        return RelationManager.getRelations(artifact, relationType, relationSide, false);
    }

    public static List<RelationLink> getRelations(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        return RelationManager.getRelations(artifact, relationType, relationSide, true);
    }

    public static List<RelationLink> getRelations(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide, boolean sort) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical.  Historical relations are only supported on server", new Object[]{artifact});
        }
        List<RelationLink> selectedRelations = relationCache.getAllByType(artifact, relationType);
        if (selectedRelations == null) {
            return Collections.emptyList();
        }
        ArrayList<RelationLink> relations = new ArrayList<RelationLink>(selectedRelations.size());
        for (RelationLink relation : selectedRelations) {
            if (relation.isDeleted()) continue;
            if (relationSide == null) {
                relations.add(relation);
                continue;
            }
            if (relation.getSide((ArtifactId)artifact) == relationSide) continue;
            relations.add(relation);
        }
        if (sort) {
            RelationManager.sortRelations(artifact, relationType, relationSide, relations);
        }
        return relations;
    }

    public static void ensureRelationCanBeAdded(RelationTypeToken relationType, Artifact artifactA, Artifact artifactB) {
        RelationManager.ensureSameBranch(artifactA, artifactB);
        RelationManager.ensureSideWillSupport(artifactA, relationType, RelationSide.SIDE_A, 1);
        RelationManager.ensureSideWillSupport(artifactB, relationType, RelationSide.SIDE_B, 1);
    }

    private static void ensureSameBranch(Artifact a, Artifact b) {
        if (!a.isOnSameBranch((HasBranch)b)) {
            throw new OseeArgumentException("Cross branch linking is not yet supported.", new Object[0]);
        }
    }

    private static void ensureSideWillSupport(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide, int artifactCount) {
        if (!relationType.isArtifactTypeAllowed(relationSide, artifact.getArtifactType())) {
            throw new OseeArgumentException(String.format("Artifact [%s] of type [%s] does not belong on side [%s] of relation [%s] - only artifacts of type [%s] are allowed", artifact.getName(), artifact.getArtifactTypeName(), relationType.getSideName(relationSide), relationType.getName(), relationType.getArtifactType(relationSide)), new Object[0]);
        }
        int nextCount = RelationManager.getRelatedArtifactsCount(artifact, relationType, relationSide.oppositeSide());
        RelationTypeMultiplicity multiplicity = relationType.getMultiplicity();
        if (!multiplicity.isWithinLimit(relationSide.oppositeSide(), nextCount += artifactCount)) {
            throw new OseeArgumentException(String.format("Artifact [%s] of type [%s] cannot be added to [%s] of relation [%s] because doing so would exceed the side maximum of [%s] for this artifact type", artifact.getName(), artifact.getArtifactTypeName(), relationSide.toString(), relationType.getName(), multiplicity.asLimitLabel(relationSide.oppositeSide())), new Object[0]);
        }
    }

    public static void deleteRelation(RelationTypeToken relationType, Artifact artifactA, Artifact artifactB) {
        RelationLink relation = relationCache.getLoadedRelation((ArtifactToken)artifactA, (ArtifactId)artifactA, (ArtifactId)artifactB, relationType, DeletionFlag.EXCLUDE_DELETED);
        Conditions.checkNotNull((Object)relation, (String)"relationLink", (String)"A relation link of type [%s] does exist in the cache between a artifact %s and b artifact %s", (Object[])new Object[]{relationType, artifactA.toStringWithId(), artifactB.toStringWithId()});
        ArtifactPersistenceManager.performDeleteRelationChecks(artifactA, relationType, new XResultData());
        relation.delete(true);
        RelationManager.updateOrderListOnDelete(artifactA, relationType, RelationSide.SIDE_B, RelationManager.getRelatedArtifacts(artifactA, relationType, RelationSide.SIDE_B));
        RelationManager.updateOrderListOnDelete(artifactB, relationType, RelationSide.SIDE_A, RelationManager.getRelatedArtifacts(artifactB, relationType, RelationSide.SIDE_A));
    }

    public static XResultData deleteRelationsAll(Artifact artifact, boolean reorderRelations, SkynetTransaction transaction, XResultData rd) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical. Historical relations are only supported on the server.", new Object[]{artifact});
        }
        List<RelationLink> selectedRelations = relationCache.getAll(artifact);
        HashSet<Pair> typesToUpdate = new HashSet<Pair>();
        if (selectedRelations != null) {
            for (RelationLink relation : selectedRelations) {
                typesToUpdate.add(new Pair((Object)relation.getRelationType(), (Object)relation.getOppositeSide((ArtifactId)artifact)));
                relation.delete(reorderRelations, transaction);
            }
        }
        for (Pair type : typesToUpdate) {
            RelationManager.updateOrderListOnDelete(artifact, (RelationTypeToken)type.getFirst(), (RelationSide)type.getSecond(), RelationManager.getRelatedArtifacts(artifact, (RelationTypeToken)type.getFirst(), (RelationSide)type.getSecond()));
        }
        return rd;
    }

    public static void deleteRelations(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical. Historical relations are only supported on the server.", new Object[]{artifact});
        }
        List<RelationLink> selectedRelations = relationCache.getAllByType(artifact, relationType);
        if (selectedRelations != null) {
            for (RelationLink relation : selectedRelations) {
                if (relation.getSide((ArtifactId)artifact) == relationSide) continue;
                relation.delete(true);
            }
        }
        RelationManager.updateOrderListOnDelete(artifact, relationType, relationSide, RelationManager.getRelatedArtifacts(artifact, relationType, relationSide));
    }

    public static void purgeRelationsFor(Artifact artifact) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical. Historical relations are only supported on the server.", new Object[]{artifact});
        }
        List<RelationLink> links = relationCache.getAll(artifact);
        if (!links.isEmpty()) {
            ArrayList<Object[]> batchArgs = new ArrayList<Object[]>(links.size());
            String PURGE_RELATION = "delete from osee_relation_link WHERE rel_link_id = ?";
            for (RelationLink link : links) {
                batchArgs.add(new Object[]{link.getId()});
                link.markAsPurged();
            }
            ConnectionHandler.runBatchUpdate(PURGE_RELATION, batchArgs);
        }
    }

    public static void addRelation(RelationTypeToken relationType, Artifact artifactA, Artifact artifactB, String rationale) {
        RelationManager.addRelation(RelationSorter.PREEXISTING, relationType, artifactA, artifactB, rationale);
    }

    public static void addRelation(RelationSorter sorterId, RelationTypeToken relationType, Artifact artifactA, Artifact artifactB, String rationale) {
        Conditions.checkExpressionFailOnTrue((boolean)artifactA.equals((Object)artifactB), (String)"Not valid to relate artifact [%s] to itself", (Object[])new Object[]{artifactA});
        RelationLink relation = relationCache.getLoadedRelation((ArtifactToken)artifactA, (ArtifactId)artifactA, (ArtifactId)artifactB, relationType, DeletionFlag.INCLUDE_DELETED);
        if (relation == null) {
            RelationManager.ensureRelationCanBeAdded(relationType, artifactA, artifactB);
            relation = RelationManager.getOrCreate(artifactA, artifactB, relationType, 0, GammaId.valueOf((int)0), rationale, ModificationType.NEW, ApplicabilityId.BASE);
            relation.setDirty();
            if (relation.isDeleted()) {
                relation.undelete();
            }
            RelationTypeSideSorter sorter = RelationManager.createTypeSideSorter(artifactA, relationType, RelationSide.SIDE_B);
            sorter.addItem(sorterId, artifactB);
        } else if (relation.isDeleted()) {
            relation.undelete();
            RelationTypeSideSorter sorter = RelationManager.createTypeSideSorter(artifactA, relationType, RelationSide.SIDE_B);
            sorter.addItem(sorterId, artifactB);
        }
    }

    public static RelationLink getRelationLink(Artifact artifactA, Artifact artifactB, RelationTypeToken relationType) {
        List<RelationLink> relationLinks = relationCache.getAllByType(artifactA, relationType);
        for (RelationLink relation : relationLinks) {
            if (!relation.getArtifactB().equals((Object)artifactB)) continue;
            return relation;
        }
        throw new OseeCoreException("Unable to find a relation link for type[%s] artA[%s] artB[%s]", new Object[]{relationType, artifactA.getName(), artifactB.getName()});
    }

    public static List<RelationSorter> getRelationOrderTypes() {
        return relationSorterProvider.getAllRelationOrderIds();
    }

    public static RelationTypeSideSorter createTypeSideSorter(Artifact artifact, RelationTypeToken relationType, RelationSide side) {
        RelationOrderData data = RelationManager.createRelationOrderData(artifact);
        return new RelationTypeSideSorter(relationType, side, relationSorterProvider, data);
    }

    public static RelationOrderData createRelationOrderData(Artifact artifact) {
        return relationOrderFactory.createRelationOrderData(artifact);
    }

    public static void setRelationOrder(Artifact artifact, RelationTypeToken relationType, RelationSide side, RelationSorter orderId, List<Artifact> relatives) {
        RelationTypeSideSorter sorter = RelationManager.createTypeSideSorter(artifact, relationType, side);
        sorter.setOrder(relatives, orderId);
    }

    private static void sort(Artifact artifact, RelationTypeToken type, RelationSide side, List<Artifact> listToOrder) {
        if (type == null || side == null || listToOrder.size() <= 1) {
            return;
        }
        RelationTypeSideSorter sorter = RelationManager.createTypeSideSorter(artifact, type, side);
        sorter.sort(listToOrder);
    }

    private static void sortRelations(Artifact artifact, RelationTypeToken type, RelationSide side, List<RelationLink> listToOrder) {
        if (type == null || side == null || listToOrder.size() <= 1) {
            return;
        }
        RelationTypeSideSorter sorter = RelationManager.createTypeSideSorter(artifact, type, side);
        sorter.sortRelations(listToOrder);
    }

    private static void updateOrderListOnDelete(Artifact artifact, RelationTypeToken relationType, RelationSide relationSide, List<Artifact> relatives) {
        RelationTypeSideSorter sorter = RelationManager.createTypeSideSorter(artifact, relationType, relationSide);
        sorter.setOrder(relatives, sorter.getSorterId());
    }

    public static void deCache(Artifact artifact) {
        relationCache.deCache(artifact);
    }

    public static synchronized RelationLink getOrCreate(ArtifactToken aArtifactId, ArtifactToken bArtifactId, RelationTypeToken relationType, int relationId, GammaId gammaId, String rationale, ModificationType modificationType, ApplicabilityId applicabilityId) {
        BranchToken branch = aArtifactId.getBranch();
        RelationLink relation = null;
        relation = relationId != 0 ? RelationManager.getLoadedRelationById(relationId, (ArtifactId)aArtifactId, (ArtifactId)bArtifactId, (BranchId)branch) : RelationManager.getLoadedRelation(relationType, aArtifactId, bArtifactId, (BranchId)branch);
        if (relation == null) {
            relation = new RelationLink(aArtifactId, bArtifactId, (BranchId)branch, relationType, relationId, gammaId, rationale, modificationType, applicabilityId);
        }
        RelationManager.manageRelation(relation, RelationSide.SIDE_A);
        RelationManager.manageRelation(relation, RelationSide.SIDE_B);
        return relation;
    }

    public static RelationLink getLoadedRelation(RelationTypeToken relationType, ArtifactToken aArtifactId, ArtifactToken bArtifactId, BranchId branch) {
        return relationCache.getLoadedRelation(relationType, aArtifactId.getId().intValue(), bArtifactId.getId().intValue(), branch);
    }

    public static RelationLink getLoadedRelationById(int relLinkId, ArtifactId aArtifactId, ArtifactId bArtifactId, BranchId branch) {
        return relationCache.getByRelIdOnArtifact(relLinkId, aArtifactId.getId().intValue(), bArtifactId.getId().intValue(), branch);
    }

    public static List<RelationLink> getRelationsAll(Artifact artifact, DeletionFlag deletionFlag) {
        if (artifact.isHistorical()) {
            throw new OseeCoreException("Artifact [%s] is historical.  Historical relations are only supported on server", new Object[]{artifact});
        }
        return relationCache.getRelations(artifact, deletionFlag);
    }
}

