/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.event.FrameworkEvent;
import org.eclipse.osee.framework.core.event.HasEventType;
import org.eclipse.osee.framework.core.event.HasNetworkSender;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.messaging.event.res.IFrameworkEventListener;
import org.eclipse.osee.framework.messaging.event.res.IOseeCoreModelEventService;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemotePersistEvent1;
import org.eclipse.osee.framework.skynet.core.event.EventSystemPreferences;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.listener.EventQosType;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.RemoteEventServiceEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerLocal;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlers;
import org.eclipse.osee.framework.skynet.core.internal.event.EventListenerRegistry;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;

public class EventTransport
implements Transport,
IFrameworkEventListener {
    private final EventSystemPreferences preferences;
    private final EventHandlers handlers;
    private final EventListenerRegistry listenerRegistry;
    private final ExecutorService executorService;
    private final IOseeCoreModelEventService messagingService;
    private volatile boolean connectionStatus;

    public EventTransport(EventSystemPreferences preferences, EventHandlers handlers, EventListenerRegistry listenerRegistry, ExecutorService executorService, IOseeCoreModelEventService messagingService) {
        this.preferences = preferences;
        this.handlers = handlers;
        this.listenerRegistry = listenerRegistry;
        this.executorService = executorService;
        this.messagingService = messagingService;
        this.connectionStatus = false;
    }

    @Override
    public void setConnected(boolean value) {
        this.connectionStatus = value;
    }

    @Override
    public boolean isConnected() {
        return this.connectionStatus;
    }

    @Override
    public boolean isLoopbackEnabled() {
        return this.preferences.isEnableRemoteEventLoopback();
    }

    @Override
    public boolean isDispatchToLocalAllowed(Sender sender) {
        boolean normalOperation;
        boolean bl = normalOperation = !this.isLoopbackEnabled();
        return normalOperation || this.isLoopbackEnabled() && sender.isRemote();
    }

    private boolean areEventsAllowed() {
        return !this.preferences.isDisableEvents();
    }

    private Sender createSender(Object sourceObject, Object event) {
        Sender sender = null;
        if (RemoteEventServiceEventType.Rem_Connected.equals(event) || RemoteEventServiceEventType.Rem_DisConnected.equals(event)) {
            sender = Sender.createSender(sourceObject);
        } else if (sourceObject instanceof Sender && ((Sender)sourceObject).isRemote()) {
            sender = (Sender)sourceObject;
        } else {
            IdeClientSession session = ClientSessionManager.getSession();
            sender = Sender.createSender(sourceObject, session);
        }
        return sender;
    }

    @Override
    public <E extends FrameworkEvent> void send(Object object, E event) {
        if (this.areEventsAllowed()) {
            Sender sender = this.createSender(object, event);
            if (event instanceof HasNetworkSender) {
                HasNetworkSender netSender = (HasNetworkSender)event;
                netSender.setNetworkSender(sender.getNetworkSender());
            }
            this.send(sender, event);
        }
    }

    @Override
    public <E extends FrameworkEvent> void send(final Sender sender, final E event) {
        if (this.areEventsAllowed()) {
            Conditions.checkNotNull((Object)sender, (String)"sender");
            Conditions.checkNotNull(event, (String)"event");
            Object handler = this.handlers.getLocalHandler(event);
            Conditions.checkNotNull(handler, (String)"eventHandler", (String)"No event handler found for [%s]", (Object[])new Object[]{event.getClass().getName()});
            Runnable runnable = new Runnable((EventHandlerLocal)handler){
                private final /* synthetic */ EventHandlerLocal val$handler;
                {
                    this.val$handler = eventHandlerLocal;
                }

                @Override
                public void run() {
                    if (EventTransport.this.preferences.isEnableRemoteEventLoopback()) {
                        EventUtil.eventLog((String)"IEM: Loopback enabled [%s] - %s", (Object[])new Object[]{event.getClass().getSimpleName(), sender.isLocal() ? "Ignoring Local Kick" : "Kicking Local from Loopback"});
                    }
                    try {
                        if (event instanceof HasEventType) {
                            HasEventType hasEventType = (HasEventType)event;
                            Conditions.checkNotNull((Object)hasEventType.getEventType(), (String)"eventType", (String)"for event [%s]", (Object[])new Object[]{event.getClass().getSimpleName()});
                        }
                        if (event instanceof HasNetworkSender) {
                            HasNetworkSender netSender = (HasNetworkSender)event;
                            Conditions.checkNotNull((Object)netSender.getNetworkSender(), (String)"networkSender", (String)"for event [%s]", (Object[])new Object[]{event.getClass().getSimpleName()});
                        }
                        this.val$handler.send(EventTransport.this, sender, event);
                    }
                    catch (Throwable th) {
                        EventUtil.eventLog((Throwable)th, (String)"IEM: Error sending event [%s] from sender [%s]", (Object[])new Object[]{event.getClass().getSimpleName(), sender});
                    }
                }
            };
            EventUtil.eventLog((String)"IEM: Dispatched Event - type[%s] to[%s]", (Object[])new Object[]{event.getClass().getSimpleName(), sender});
            this.execute(runnable);
        }
    }

    @Override
    public <E extends FrameworkEvent, L extends IEventListener, H extends EventHandlerLocal<L, E>> void sendLocal(Sender sender, E event) {
        Object handler = this.handlers.getLocalHandler(event);
        Conditions.checkNotNull(handler, (String)"localEventHandler", (String)"No local event handler available for event [%s]", (Object[])new Object[]{event.getClass().getName()});
        EventUtil.eventLog((String)"IEM: processing event [%s]", (Object[])new Object[]{event});
        EventQosType[] eventQosTypeArray = EventQosType.values();
        int n = eventQosTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventQosType qos = eventQosTypeArray[n2];
            Collection listeners = this.listenerRegistry.getListeners(qos, event);
            for (IEventListener listener : listeners) {
                try {
                    handler.handle((IEventListener)listener, sender, event);
                }
                catch (Exception ex) {
                    EventUtil.eventLog((Throwable)ex, (String)"IEM: Error processing - qos[%s] event[%s]", (Object[])new Object[]{qos, event});
                }
            }
            ++n2;
        }
        EventUtil.eventLog((String)"IEM: processed event [%s]", (Object[])new Object[]{event});
    }

    @Override
    public void sendRemote(final RemoteEvent remoteEvent) {
        if (this.isConnected()) {
            EventUtil.eventLog((String)String.format("IEM: kick - [%s]", remoteEvent), (Object[])new Object[0]);
            Job job = new Job(String.format("[%s] - sending [%s]", this.getClass().getSimpleName(), remoteEvent.getClass().getSimpleName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        EventTransport.this.messagingService.sendRemoteEvent(remoteEvent);
                    }
                    catch (Exception ex) {
                        EventUtil.eventLog((String)"IEM: kick", (Throwable)ex);
                        return new Status(4, "org.eclipse.osee.framework.skynet.core", -1, ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        if (this.preferences.isEnableRemoteEventLoopback()) {
            EventUtil.eventLog((String)"IEM: Loopback enabled - Returning events as Remote event.", (Object[])new Object[0]);
            String newSessionId = GUID.create();
            remoteEvent.getNetworkSender().setSessionId(newSessionId);
            this.onEvent(remoteEvent);
        }
    }

    public void onEvent(final RemoteEvent remoteEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Sender sender;
                    if (remoteEvent != null && !(sender = Sender.createSender(remoteEvent.getNetworkSender())).isLocal()) {
                        EventTransport.this.handleEvent(sender, remoteEvent);
                    }
                }
                catch (Throwable th) {
                    EventUtil.eventLog((String)"IEM: RemoteEvent - onEvent", (Throwable)th);
                }
            }
        };
        this.execute(runnable);
    }

    private <E extends RemoteEvent> void handleEvent(Sender sender, E event) {
        Object handler = this.handlers.getRemoteHandler(event);
        Conditions.checkNotNull(handler, (String)"remoteEventHandler", (String)"No remote event handler available for event [%s]", (Object[])new Object[]{event.getClass().getName()});
        EventUtil.eventLog((String)"IEM: processing remote event [%s]", (Object[])new Object[]{event});
        handler.handle(this, sender, event);
        EventUtil.eventLog((String)"IEM: processed remote event [%s]", (Object[])new Object[]{event});
    }

    private void execute(Runnable runnable) {
        if (this.preferences.isPendRunning()) {
            runnable.run();
        } else {
            this.executorService.submit(runnable);
        }
    }

    public void sendCommitEvent(final Class<?> class1, final ArtifactEvent artifactEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Sender sender = Sender.createSender(class1);
                    artifactEvent.setNetworkSender(sender.getNetworkSender());
                    RemotePersistEvent1 remoteEvent = FrameworkEventUtil.getRemotePersistEvent(artifactEvent);
                    EventUtil.eventLog((String)"IEM: processing commit remote event [%s]", (Object[])new Object[]{artifactEvent});
                    EventTransport.this.handleEvent(sender, (RemoteEvent)remoteEvent);
                    EventUtil.eventLog((String)"IEM: processed commit remote event [%s]", (Object[])new Object[]{artifactEvent});
                }
                catch (Throwable th) {
                    EventUtil.eventLog((String)"IEM: RemoteEvent - onEvent", (Throwable)th);
                }
            }
        };
        this.execute(runnable);
    }
}

