/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.parsers.WordOutlineExtractorDelegate;

public abstract class SoftwareRequirementHandler
extends WordOutlineExtractorDelegate {
    private static final Pattern partitionPattern = Pattern.compile("\\[([\\w\\(|\\)]+)\\]");
    private final AttributeTypeToken attributeType;

    protected SoftwareRequirementHandler(AttributeTypeToken attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public void processHeadingText(RoughArtifact roughArtifact, String headingText) {
        StringBuilder text = new StringBuilder(headingText);
        Matcher matcher = partitionPattern.matcher(text);
        boolean isRequirement = false;
        while (matcher.find()) {
            isRequirement = true;
            roughArtifact.addAttribute(this.attributeType, matcher.group(1).trim());
            text.delete(matcher.start(), matcher.end());
            matcher.reset(text);
        }
        if (!isRequirement) {
            roughArtifact.setArtifactType(CoreArtifactTypes.HeadingMsWord);
        }
        roughArtifact.setName(text.toString().trim());
    }
}

