/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.event.NetworkSender;
import org.eclipse.osee.framework.core.event.TopicEvent;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicUuidRelationReorder;
import org.eclipse.osee.framework.core.model.event.RelationOrderModType;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.messaging.event.res.RemoteTopicEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteAttributeChange1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBasicGuidArtifact1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBasicGuidRelation1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBasicGuidRelationReorder1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBranchEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteNetworkSender1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemotePersistEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteTransactionChange1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteTransactionEvent1;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.AttributeChange;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventChangeTypeBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventModifiedBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionChange;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEventType;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;

public final class FrameworkEventUtil {
    private FrameworkEventUtil() {
    }

    public static RemoteBranchEvent1 getRemoteBranchEvent(BranchEvent branchEvent) {
        RemoteBranchEvent1 event = new RemoteBranchEvent1();
        event.setEventTypeGuid(branchEvent.getEventType().getGuid());
        event.setBranch(branchEvent.getSourceBranch());
        event.setDestinationBranch(branchEvent.getDestinationBranch());
        event.setNetworkSender(FrameworkEventUtil.getRemoteNetworkSender(branchEvent.getNetworkSender()));
        return event;
    }

    public static BranchEvent getBranchEvent(RemoteBranchEvent1 branchEvent) {
        BranchEventType branchEventType = BranchEventType.getByGuid(branchEvent.getEventTypeGuid());
        if (branchEventType != null) {
            BranchEvent event = new BranchEvent(branchEventType, branchEvent.getBranch(), branchEvent.getDestinationBranch());
            event.setNetworkSender(FrameworkEventUtil.getNetworkSender(branchEvent.getNetworkSender()));
            return event;
        }
        OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("Unhandled branch event type guid " + branchEvent.getBranchGuid()));
        return null;
    }

    public static RemoteTransactionEvent1 getRemoteTransactionEvent(TransactionEvent transEvent) {
        RemoteTransactionEvent1 event = new RemoteTransactionEvent1();
        event.setNetworkSender(FrameworkEventUtil.getRemoteNetworkSender(transEvent.getNetworkSender()));
        event.setEventTypeGuid(transEvent.getEventType().getGuid());
        for (TransactionChange change : transEvent.getTransactionChanges()) {
            RemoteTransactionChange1 remChange = new RemoteTransactionChange1();
            remChange.setBranchGuid(change.getBranch().getId());
            remChange.setTransactionId(change.getTransactionId());
            List remChangeArts = remChange.getArtifacts();
            for (DefaultBasicGuidArtifact guidArt : change.getArtifacts()) {
                remChangeArts.add(FrameworkEventUtil.getRemoteBasicGuidArtifact(guidArt));
            }
            event.getTransactions().add(remChange);
        }
        return event;
    }

    public static TransactionEvent getTransactionEvent(RemoteTransactionEvent1 remEvent, OrcsTokenService tokenService) {
        TransactionEvent event = new TransactionEvent();
        event.setNetworkSender(FrameworkEventUtil.getNetworkSender(remEvent.getNetworkSender()));
        event.setEventType(TransactionEventType.getByGuid(remEvent.getEventTypeGuid()));
        for (RemoteTransactionChange1 remChange : remEvent.getTransactions()) {
            TransactionChange change = new TransactionChange();
            change.setBranch(BranchId.valueOf((String)remChange.getBranchGuid()));
            change.setTransactionId(remChange.getTransactionId());
            Collection<DefaultBasicGuidArtifact> eventArts = change.getArtifacts();
            for (RemoteBasicGuidArtifact1 remGuidArt : remChange.getArtifacts()) {
                eventArts.add(FrameworkEventUtil.getBasicGuidArtifact(remGuidArt, tokenService));
            }
            event.addTransactionChange(change);
        }
        return event;
    }

    public static RemotePersistEvent1 getRemotePersistEvent(ArtifactEvent transEvent) {
        RemotePersistEvent1 event = new RemotePersistEvent1();
        event.setNetworkSender(FrameworkEventUtil.getRemoteNetworkSender(transEvent.getNetworkSender()));
        event.setBranchGuid(transEvent.getBranch());
        event.setTransaction(transEvent.getTransactionId());
        for (EventBasicGuidArtifact guidArt : transEvent.getArtifacts()) {
            if (guidArt.getModType() == EventModType.Modified) {
                event.getArtifacts().add(FrameworkEventUtil.getRemoteBasicGuidArtifact(guidArt.getModType().getGuid(), guidArt, ((EventModifiedBasicGuidArtifact)guidArt).getAttributeChanges()));
                continue;
            }
            if (guidArt.getModType() == EventModType.ChangeType) {
                EventChangeTypeBasicGuidArtifact changeGuidArt = (EventChangeTypeBasicGuidArtifact)guidArt;
                RemoteBasicGuidArtifact1 remGuidArt = FrameworkEventUtil.getRemoteBasicGuidArtifact(guidArt.getModType().getGuid(), guidArt, null);
                remGuidArt.setArtifactType(changeGuidArt.getFromArtTypeGuid());
                remGuidArt.setToArtifactType((ArtifactTypeId)changeGuidArt.getArtifactType());
                event.getArtifacts().add(remGuidArt);
                continue;
            }
            event.getArtifacts().add(FrameworkEventUtil.getRemoteBasicGuidArtifact(guidArt.getModType().getGuid(), guidArt, null));
        }
        for (EventBasicGuidRelation guidRel : transEvent.getRelations()) {
            event.getRelations().add(FrameworkEventUtil.getRemoteBasicGuidRelation1(guidRel));
        }
        for (DefaultBasicUuidRelationReorder guidOrderRel : transEvent.getRelationOrderRecords()) {
            event.getRelationReorders().add(FrameworkEventUtil.getRemoteBasicGuidRelationReorder1(guidOrderRel));
        }
        return event;
    }

    public static ArtifactEvent getPersistEvent(RemotePersistEvent1 remEvent, OrcsTokenService tokenService) {
        ArtifactEvent event = new ArtifactEvent(remEvent.getTransaction());
        event.setNetworkSender(FrameworkEventUtil.getNetworkSender(remEvent.getNetworkSender()));
        for (RemoteBasicGuidArtifact1 remGuidArt : remEvent.getArtifacts()) {
            EventModType modType = EventModType.getType(remGuidArt.getModTypeGuid());
            if (modType == null) {
                OseeLog.logf(Activator.class, (Level)Level.WARNING, (String)"Unhandled remote artifact [%s]", (Object[])new Object[]{remGuidArt});
                continue;
            }
            if (modType == EventModType.Modified) {
                event.addArtifact(FrameworkEventUtil.getEventModifiedBasicGuidArtifact(modType, remGuidArt, tokenService));
                continue;
            }
            if (modType == EventModType.ChangeType) {
                event.addArtifact(FrameworkEventUtil.getEventChangeTypeBasicGuidArtifact(modType, remGuidArt, tokenService));
                continue;
            }
            event.addArtifact(FrameworkEventUtil.getEventBasicGuidArtifact(modType, remGuidArt, tokenService));
        }
        for (RemoteBasicGuidRelation1 guidRel : remEvent.getRelations()) {
            EventBasicGuidRelation relEvent = FrameworkEventUtil.getEventBasicGuidRelation(guidRel, tokenService);
            if (relEvent == null) {
                OseeLog.logf(Activator.class, (Level)Level.WARNING, (String)"Unhandled remote relation [%s]", (Object[])new Object[]{guidRel});
                continue;
            }
            event.getRelations().add(relEvent);
        }
        for (RemoteBasicGuidRelationReorder1 guidReorder : remEvent.getRelationReorders()) {
            event.getRelationOrderRecords().add(FrameworkEventUtil.getDefaultBasicGuidRelationReorder(guidReorder, tokenService));
        }
        return event;
    }

    public static DefaultBasicUuidRelationReorder getDefaultBasicGuidRelationReorder(RemoteBasicGuidRelationReorder1 guidRelOrder, OrcsTokenService tokenService) {
        DefaultBasicUuidRelationReorder guidArt = new DefaultBasicUuidRelationReorder(RelationOrderModType.getType((String)guidRelOrder.getModTypeGuid()), BranchId.valueOf((String)guidRelOrder.getBranchGuid()), Long.valueOf(guidRelOrder.getRelTypeGuid()), FrameworkEventUtil.getBasicGuidArtifact(guidRelOrder.getParentArt(), tokenService));
        return guidArt;
    }

    public static RemoteBasicGuidRelation1 getRemoteBasicGuidRelation1(EventBasicGuidRelation guidRel) {
        RemoteBasicGuidRelation1 remEvent = new RemoteBasicGuidRelation1();
        remEvent.setGammaId(guidRel.getGammaId().getIdIntValue());
        remEvent.setBranchGuid(guidRel.getBranch());
        remEvent.setRelTypeGuid(guidRel.getRelTypeGuid().longValue());
        remEvent.setRelationId(guidRel.getRelationId().intValue());
        remEvent.setArtAId(guidRel.getArtAId());
        remEvent.setArtBId(guidRel.getArtBId());
        remEvent.setModTypeGuid(guidRel.getModType().getGuid());
        remEvent.setArtA(FrameworkEventUtil.getRemoteBasicGuidArtifact(guidRel.getArtA()));
        remEvent.setArtB(FrameworkEventUtil.getRemoteBasicGuidArtifact(guidRel.getArtB()));
        remEvent.setRationale(guidRel.getRationale());
        return remEvent;
    }

    public static RemoteBasicGuidArtifact1 getRemoteBasicGuidArtifact(DefaultBasicGuidArtifact guidArt) {
        RemoteBasicGuidArtifact1 event = new RemoteBasicGuidArtifact1();
        event.setBranch(guidArt.getBranch());
        event.setArtifactType((ArtifactTypeId)guidArt.getArtifactType());
        event.setArtGuid((String)guidArt.getGuid());
        return event;
    }

    public static RemoteBasicGuidRelationReorder1 getRemoteBasicGuidRelationReorder1(DefaultBasicUuidRelationReorder guidOrderRel) {
        RemoteBasicGuidRelationReorder1 event = new RemoteBasicGuidRelationReorder1();
        event.setBranchGuid(guidOrderRel.getBranch());
        event.setRelTypeGuid(guidOrderRel.getRelTypeGuid().longValue());
        event.setModTypeGuid(guidOrderRel.getModType().getGuid());
        event.setParentArt(FrameworkEventUtil.getRemoteBasicGuidArtifact(guidOrderRel.getParentArt()));
        return event;
    }

    public static EventBasicGuidRelation getEventBasicGuidRelation(RemoteBasicGuidRelation1 guidRel, OrcsTokenService tokenService) {
        RelationEventType eventType = RelationEventType.getType(guidRel.getModTypeGuid());
        if (eventType == null) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("Can't determine RelationEventType from guid " + guidRel.getModTypeGuid()));
        }
        EventBasicGuidRelation event = new EventBasicGuidRelation(eventType, guidRel.getBranch(), guidRel.getRelTypeGuid(), Long.valueOf(guidRel.getRelationId()), GammaId.valueOf((int)guidRel.getGammaId()), guidRel.getArtAId(), FrameworkEventUtil.getBasicGuidArtifact(guidRel.getArtA(), tokenService), guidRel.getArtBId(), FrameworkEventUtil.getBasicGuidArtifact(guidRel.getArtB(), tokenService));
        if (eventType == RelationEventType.ModifiedRationale || eventType == RelationEventType.Added) {
            event.setRationale(guidRel.getRationale());
        }
        return event;
    }

    public static EventBasicGuidArtifact getEventBasicGuidArtifact(EventModType modType, RemoteBasicGuidArtifact1 remGuidArt, OrcsTokenService tokenService) {
        return new EventBasicGuidArtifact(modType, remGuidArt.getBranch(), tokenService.getArtifactType(Long.valueOf(remGuidArt.getArtTypeGuid())), remGuidArt.getArtGuid());
    }

    public static EventChangeTypeBasicGuidArtifact getEventChangeTypeBasicGuidArtifact(EventModType modType, RemoteBasicGuidArtifact1 remGuidArt, OrcsTokenService tokenService) {
        return new EventChangeTypeBasicGuidArtifact(remGuidArt.getBranch(), remGuidArt.getArtifactType(), tokenService.getArtifactType(Long.valueOf(remGuidArt.getToArtTypeGuid())), remGuidArt.getArtGuid());
    }

    public static EventModifiedBasicGuidArtifact getEventModifiedBasicGuidArtifact(EventModType modType, RemoteBasicGuidArtifact1 remGuidArt, OrcsTokenService tokenService) {
        ArrayList<AttributeChange> attributeChanges = new ArrayList<AttributeChange>();
        for (RemoteAttributeChange1 remAttrChg : remGuidArt.getAttributes()) {
            attributeChanges.add(FrameworkEventUtil.getAttributeChange(remAttrChg));
        }
        return new EventModifiedBasicGuidArtifact(remGuidArt.getBranch(), tokenService.getArtifactType(Long.valueOf(remGuidArt.getArtTypeGuid())), remGuidArt.getArtGuid(), attributeChanges);
    }

    private static DefaultBasicGuidArtifact getBasicGuidArtifact(RemoteBasicGuidArtifact1 remGuidArt, OrcsTokenService tokenService) {
        return new DefaultBasicGuidArtifact(remGuidArt.getBranch(), tokenService.getArtifactType(Long.valueOf(remGuidArt.getArtTypeGuid())), remGuidArt.getArtGuid());
    }

    public static RemoteBasicGuidArtifact1 getRemoteBasicGuidArtifact(String modTypeGuid, DefaultBasicGuidArtifact guidArt, Collection<AttributeChange> attributeChanges) {
        RemoteBasicGuidArtifact1 remoteGuidArt = new RemoteBasicGuidArtifact1();
        remoteGuidArt.setArtGuid((String)guidArt.getGuid());
        remoteGuidArt.setBranch(guidArt.getBranch());
        remoteGuidArt.setArtifactType((ArtifactTypeId)guidArt.getArtifactType());
        remoteGuidArt.setModTypeGuid(modTypeGuid);
        if (attributeChanges != null) {
            for (AttributeChange attrChg : attributeChanges) {
                remoteGuidArt.getAttributes().add(FrameworkEventUtil.getRemoteAttributeChange(attrChg));
            }
        }
        return remoteGuidArt;
    }

    public static AttributeChange getAttributeChange(RemoteAttributeChange1 remAttrChg) {
        AttributeChange attrChg = new AttributeChange();
        attrChg.setAttributeId(remAttrChg.getAttributeId());
        attrChg.setGammaId(GammaId.valueOf((int)remAttrChg.getGammaId()));
        attrChg.setAttrTypeGuid(remAttrChg.getAttrTypeGuid());
        attrChg.setModTypeGuid(remAttrChg.getModTypeGuid());
        for (Object data : remAttrChg.getData()) {
            attrChg.getData().add(data);
        }
        return attrChg;
    }

    public static RemoteAttributeChange1 getRemoteAttributeChange(AttributeChange attrChg) {
        RemoteAttributeChange1 remAttrChg = new RemoteAttributeChange1();
        remAttrChg.setAttributeId(attrChg.getAttributeId());
        remAttrChg.setGammaId(attrChg.getGammaId().getIdIntValue());
        remAttrChg.setAttrTypeGuid(attrChg.getAttrTypeGuid().longValue());
        remAttrChg.setModTypeGuid(attrChg.getModTypeGuid());
        for (Object data : attrChg.getData()) {
            remAttrChg.getData().add(data.toString());
        }
        return remAttrChg;
    }

    public static NetworkSender getNetworkSender(RemoteNetworkSender1 remSender) {
        NetworkSender networkSender = new NetworkSender((Object)remSender.getSourceObject(), remSender.getSessionId(), remSender.getMachineName(), remSender.getUserId(), remSender.getMachineIp(), remSender.getPort(), remSender.getClientVersion());
        return networkSender;
    }

    public static RemoteNetworkSender1 getRemoteNetworkSender(NetworkSender localSender) {
        RemoteNetworkSender1 networkSender = new RemoteNetworkSender1();
        networkSender.setSourceObject(String.valueOf(localSender.sourceObject));
        networkSender.setSessionId(localSender.sessionId);
        networkSender.setMachineName(localSender.machineName);
        networkSender.setUserId(localSender.userId);
        networkSender.setMachineIp(localSender.machineIp);
        networkSender.setPort(localSender.port);
        networkSender.setClientVersion(localSender.clientVersion);
        return networkSender;
    }

    public static RemoteEvent getRemoteTopicEvent(TopicEvent event) {
        RemoteTopicEvent1 remEvent = new RemoteTopicEvent1();
        remEvent.setNetworkSender(FrameworkEventUtil.getRemoteNetworkSender(event.getNetworkSender()));
        remEvent.getProperties().putAll(event.getProperties());
        remEvent.setTopic(event.getTopic());
        return remEvent;
    }

    public static TopicEvent getTopicEvent(RemoteTopicEvent1 remoteEvent) {
        TopicEvent event = new TopicEvent(remoteEvent.getTopic());
        event.getProperties().putAll(remoteEvent.getProperties());
        event.setNetworkSender(FrameworkEventUtil.getNetworkSender(remoteEvent.getNetworkSender()));
        return event;
    }
}

