/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.conflict;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcStatement;

public class ConflictStatusManager {
    private static final String MERGE_UPDATE_STATUS = "UPDATE osee_conflict SET status = ? WHERE source_gamma_id = ? AND dest_gamma_id = ? AND merge_branch_id = ?";
    private static final String MERGE_INSERT_STATUS = "insert into osee_conflict ( conflict_id, merge_branch_id, source_gamma_id, dest_gamma_id, status, conflict_type) VALUES ( ?, ?, ?, ?, ?, ?)";
    private static final String MERGE_ATTRIBUTE_STATUS = "SELECT source_gamma_id, dest_gamma_id, status FROM osee_conflict WHERE merge_branch_id = ? AND conflict_id = ? AND conflict_type = ?";
    private static final String MERGE_UPDATE_GAMMAS = "UPDATE osee_conflict SET source_gamma_id = ?, dest_gamma_id = ?, status = ? WHERE merge_branch_id = ? AND conflict_id = ? AND conflict_type = ?";
    private static final String MERGE_BRANCH_GAMMAS = "UPDATE osee_txs SET gamma_id = ? where (transaction_id, gamma_id) = (SELECT tx.transaction_id, tx.gamma_id FROM osee_txs tx, osee_attribute atr WHERE tx.branch_id = ? AND tx.transaction_id = ? AND atr.gamma_id = tx.gamma_id AND atr.attr_id = ? )";

    public static void setStatus(ConflictStatus status, GammaId sourceGamma, GammaId destGamma, BranchId mergeBranch) {
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            ConnectionHandler.runPreparedUpdate(MERGE_UPDATE_STATUS, status.getValue(), sourceGamma, destGamma, mergeBranch);
        }
    }

    public static ConflictStatus computeStatus(GammaId sourceGamma, GammaId destGamma, BranchId branch, Id objectID, int conflictType, ConflictStatus passedStatus, TransactionId transactionId) {
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(MERGE_ATTRIBUTE_STATUS, new Object[]{branch, objectID, conflictType});
            if (chStmt.next()) {
                int intStatus = chStmt.getInt("status");
                if (sourceGamma.notEqual(Long.valueOf(chStmt.getLong("source_gamma_id"))) || destGamma.notEqual(Long.valueOf(chStmt.getLong("dest_gamma_id"))) && intStatus != ConflictStatus.COMMITTED.getValue()) {
                    if (intStatus == ConflictStatus.RESOLVED.getValue() || intStatus == ConflictStatus.PREVIOUS_MERGE_APPLIED_SUCCESS.getValue()) {
                        intStatus = ConflictStatus.OUT_OF_DATE_RESOLVED.getValue();
                    }
                    if (intStatus == ConflictStatus.EDITED.getValue() || intStatus == ConflictStatus.PREVIOUS_MERGE_APPLIED_CAUTION.getValue()) {
                        intStatus = ConflictStatus.OUT_OF_DATE.getValue();
                    }
                    ConnectionHandler.runPreparedUpdate(MERGE_UPDATE_GAMMAS, sourceGamma, destGamma, intStatus, branch, objectID, conflictType);
                    if (conflictType == ConflictType.ATTRIBUTE.getValue()) {
                        ConnectionHandler.runPreparedUpdate(MERGE_BRANCH_GAMMAS, sourceGamma, branch, transactionId, objectID);
                    }
                }
                if (intStatus == ConflictStatus.INFORMATIONAL.getValue() || passedStatus == ConflictStatus.INFORMATIONAL) {
                    intStatus = passedStatus.getValue();
                }
                ConflictStatus conflictStatus = ConflictStatus.valueOf((int)intStatus);
                return conflictStatus;
            }
        }
        ConnectionHandler.runPreparedUpdate(MERGE_INSERT_STATUS, objectID, branch, sourceGamma, destGamma, passedStatus.getValue(), conflictType);
        return passedStatus;
    }
}

