/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.search.ISearchPrimitive;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;

public class AttributeValueSearch
implements ISearchPrimitive {
    private final AttributeTypeId attributeType;
    private final String attributeValue;
    private static final String TOKEN = ";";

    public AttributeValueSearch(AttributeTypeId attributeType, String attributeValue) {
        Conditions.checkNotNull((Object)attributeType, (String)"attributeType");
        Conditions.checkNotNullOrEmpty((String)attributeValue, (String)"attributeValue");
        this.attributeType = attributeType;
        this.attributeValue = attributeValue;
    }

    @Override
    public String getStorageString() {
        return String.valueOf(this.attributeType.getIdString()) + TOKEN + this.attributeValue;
    }

    public static AttributeValueSearch getPrimitive(String storageString) {
        String[] values = storageString.split(TOKEN);
        if (values.length != 2) {
            throw new IllegalStateException("Value for " + AttributeValueSearch.class.getSimpleName() + " not parsable");
        }
        AttributeTypeGeneric type = AttributeTypeToken.valueOf((Long)Long.valueOf(values[0]), (String)"SearchAttrType");
        return new AttributeValueSearch((AttributeTypeId)type, values[1]);
    }

    @Override
    public void addToQuery(QueryBuilderArtifact builder) {
        builder.and(this.attributeType, this.attributeValue, QueryOption.CONTAINS_MATCH_OPTIONS);
    }

    public String toString() {
        return "AttributeValueSearch [attributeType=" + this.attributeType + ", value=" + this.attributeValue + "]";
    }
}

