/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.search.ISearchPrimitive;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;

public class AttributeNotExistsSearch
implements ISearchPrimitive {
    private final List<AttributeTypeId> attributeTypes;

    public AttributeNotExistsSearch(List<AttributeTypeId> attributeTypes) {
        Conditions.checkNotNull(attributeTypes, (String)"attributeTypes");
        this.attributeTypes = attributeTypes;
    }

    public String toString() {
        return "Attribute Not Exists type: \"" + this.attributeTypes + "\"";
    }

    @Override
    public String getStorageString() {
        StringBuilder storageString = new StringBuilder();
        for (AttributeTypeId attrType : this.attributeTypes) {
            storageString.append(attrType.getIdString());
            storageString.append(",");
        }
        storageString.deleteCharAt(storageString.length() - 1);
        return storageString.toString();
    }

    public static AttributeNotExistsSearch getPrimitive(String storageString) {
        ArrayList<AttributeTypeId> attributeTypes = new ArrayList<AttributeTypeId>();
        String[] stringArray = storageString.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeTypeId = stringArray[n2];
            attributeTypes.add((AttributeTypeId)AttributeTypeToken.valueOf((Long)Long.valueOf(attributeTypeId), (String)"SearchAttrType"));
            ++n2;
        }
        return new AttributeNotExistsSearch(attributeTypes);
    }

    @Override
    public void addToQuery(QueryBuilderArtifact builder) {
        builder.andNotExists(this.attributeTypes);
    }
}

