/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;

public class NextVersionSearchItem
extends WorldUISearchItem {
    private final IAtsTeamDefinition teamDefHoldingVersions;
    private IAtsTeamDefinition selectedTeamDef;
    private IAtsVersion selectedVersionArt;

    public NextVersionSearchItem(IAtsTeamDefinition teamDefHoldingVersions, WorldSearchItem.LoadView loadView) {
        this(null, teamDefHoldingVersions, loadView);
    }

    public NextVersionSearchItem(String name, IAtsTeamDefinition teamDefHoldingVersions, WorldSearchItem.LoadView loadView) {
        super(name != null ? name : "Workflows Targeted-For Next Version", loadView, AtsImage.VERSION_NEXT);
        this.teamDefHoldingVersions = teamDefHoldingVersions;
    }

    public NextVersionSearchItem(NextVersionSearchItem nextVersionSearchItem) {
        super(nextVersionSearchItem, AtsImage.VERSION);
        this.teamDefHoldingVersions = nextVersionSearchItem.teamDefHoldingVersions;
        this.selectedTeamDef = nextVersionSearchItem.selectedTeamDef;
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        String name = super.getName();
        IAtsTeamDefinition teamDef = this.getTeamDefinition();
        try {
            if (teamDef != null) {
                name = String.valueOf(name) + " - " + teamDef.getName();
                this.selectedVersionArt = AtsApiService.get().getVersionService().getNextReleaseVersion(teamDef);
                name = String.valueOf(name) + (this.selectedVersionArt != null ? " - " + this.selectedVersionArt.getName() : "");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "Exception Occurred - See Log - " + ex.getLocalizedMessage();
        }
        return name;
    }

    private IAtsTeamDefinition getTeamDefinition() {
        if (this.teamDefHoldingVersions != null) {
            return this.teamDefHoldingVersions;
        }
        return this.selectedTeamDef;
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        if (AtsApiService.get().getVersionService().getNextReleaseVersion(this.getTeamDefinition()) == null) {
            AWorkbench.popup((String)"ERROR", (String)("No version marked as Next Release for \"" + this.getTeamDefinition() + "\""));
            return EMPTY_SET;
        }
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        List castAll = Collections.castAll((Collection)AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(AtsApiService.get().getVersionService().getNextReleaseVersion(this.getTeamDefinition())));
        arts.addAll(castAll);
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        return arts;
    }

    @Override
    public void performUI(WorldSearchItem.SearchType searchType) {
        super.performUI(searchType);
        if (this.teamDefHoldingVersions != null) {
            return;
        }
        if (searchType == WorldSearchItem.SearchType.ReSearch && this.selectedTeamDef != null) {
            return;
        }
        try {
            TeamDefinitionDialog dialog = new TeamDefinitionDialog();
            dialog.setInput(AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Active));
            int result = dialog.open();
            if (result == 0) {
                this.selectedTeamDef = (IAtsTeamDefinition)dialog.getSelectedFirst();
                return;
            }
            this.cancelled = true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        this.cancelled = true;
    }

    @Override
    public WorldUISearchItem copy() {
        return new NextVersionSearchItem(this);
    }

    public IAtsVersion getSelectedVersionArt() {
        return this.selectedVersionArt;
    }
}

