/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class AttributeValueQuickSearch {
    private final Collection<String> values;
    private final AttributeTypeId attributeType;

    public AttributeValueQuickSearch(AttributeTypeId attributeType, Collection<String> values) {
        this.attributeType = attributeType;
        this.values = values;
    }

    public Collection<Artifact> performSearch() {
        return this.performSearch(false);
    }

    public Collection<Artifact> performSearch(boolean exactMatch) {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        if (this.values != null && this.values.size() > 0) {
            for (String value : this.values) {
                List searchResult = ArtifactQuery.getArtifactListFromAttributeKeywords((BranchId)AtsApiService.get().getAtsBranch(), (String)value, (boolean)false, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED, (boolean)false, (AttributeTypeId[])new AttributeTypeId[]{this.attributeType});
                if (exactMatch) {
                    for (Artifact artifact : searchResult) {
                        block2: for (String value2 : this.values) {
                            for (Attribute attribute : artifact.getAttributes(this.attributeType)) {
                                if (!attribute.convertToStorageString(attribute.getValue()).equals(value2)) continue;
                                results.add(artifact);
                                continue block2;
                            }
                        }
                    }
                    continue;
                }
                results.addAll(searchResult);
            }
        }
        return results;
    }
}

