/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.mini;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.WorldContentProvider;
import org.eclipse.osee.ats.ide.world.WorldLabelProvider;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValue;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class XMiniWorldWidget
extends GenericXWidget {
    private WorldXViewer xWorldViewer;
    public static final String normalColor = "#EEEEEE";
    private static final int paddedTableHeightHint = 2;
    private Label extraInfoLabel;
    private int lastSize = 0;
    private final int MAX_TABLE_SIZE = 10;
    protected Composite mainComp;
    private Composite parentComp;
    protected final AtsApi atsApi;
    private Collection<IAtsWorkItem> workItems;
    private XLabelValue pointsLabel;
    private final IXViewerFactory xViewerFactory;

    public XMiniWorldWidget(String label, IXViewerFactory xViewerFactory) {
        super(label);
        this.xViewerFactory = xViewerFactory;
        this.atsApi = AtsApiService.get();
    }

    public abstract Collection<IAtsWorkItem> getWorkItems();

    public Collection<IAtsWorkItem> getItems() {
        return this.workItems;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.parentComp = new Composite(parent, 0x800000);
        this.parentComp.setLayoutData((Object)new GridData(768));
        this.parentComp.setLayout((Layout)ALayout.getZeroMarginLayout());
        this.redrawComposite();
    }

    public WorldXViewer createWorldXViewer(Composite tableComp, IXViewerFactory xViewerFactory) {
        return new WorldXViewer(tableComp, 67586, xViewerFactory, null);
    }

    private void redrawComposite() {
        if (this.parentComp == null || !Widgets.isAccessible((Widget)this.parentComp)) {
            return;
        }
        if (this.mainComp != null && Widgets.isAccessible((Widget)this.mainComp)) {
            this.mainComp.dispose();
            this.xWorldViewer = null;
        }
        this.mainComp = new Composite(this.parentComp, 0x800000);
        this.mainComp.setLayoutData((Object)new GridData(768));
        this.mainComp.setLayout((Layout)new GridLayout(1, true));
        if (this.toolkit != null) {
            this.toolkit.paintBordersFor(this.mainComp);
        }
        this.labelWidget = new Label(this.mainComp, 0);
        this.labelWidget.setText(String.valueOf(this.getLabel()) + ":");
        if (this.getToolTip() != null) {
            this.labelWidget.setToolTipText(this.getToolTip());
        }
        try {
            Composite tableComp = new Composite(this.mainComp, 2048);
            GridData gd = new GridData(768);
            tableComp.setLayoutData((Object)gd);
            tableComp.setLayout((Layout)ALayout.getZeroMarginLayout());
            if (this.toolkit != null) {
                this.toolkit.paintBordersFor(tableComp);
            }
            ToolBar toolBar = this.createActionBar(tableComp);
            this.xWorldViewer = this.createWorldXViewer(tableComp, this.xViewerFactory);
            this.xWorldViewer.getTree().setLayoutData((Object)new GridData(768));
            this.xWorldViewer.setContentProvider((IContentProvider)new WorldContentProvider(this.xWorldViewer));
            this.xWorldViewer.setLabelProvider((IBaseLabelProvider)this.createWorldLabelProvider(this.xWorldViewer));
            new ActionContributionItem((IAction)this.xWorldViewer.getCustomizeAction()).fill(toolBar, -1);
            if (this.toolkit != null && this.xWorldViewer.getStatusLabel() != null) {
                this.toolkit.adapt((Control)this.xWorldViewer.getStatusLabel(), false, false);
            }
            this.pointsLabel = new XLabelValue("Total Estimated Points", "0");
            this.pointsLabel.createWidgets(tableComp, 2);
            this.pointsLabel.getComp().setLayout((Layout)new GridLayout(2, false));
            this.pointsLabel.getLabelWidget().setFont(FontManager.getCourierNew12Bold());
            if (this.toolkit != null) {
                this.toolkit.adapt((Control)this.pointsLabel.getLabelWidget(), false, false);
                this.toolkit.adapt((Control)this.pointsLabel.getValueTextWidget(), false, false);
            }
            this.refresh();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        WorkflowEditor.setLabelFonts((Control)this.labelWidget, FontManager.getDefaultLabelFont());
        this.parentComp.layout();
    }

    protected abstract WorldLabelProvider createWorldLabelProvider(WorldXViewer var1);

    public abstract ToolBar createActionBar(Composite var1);

    public void setXviewerTreeSize() {
        Tree tree = this.xWorldViewer.getTree();
        int size = this.xWorldViewer.getTree().getItemCount();
        if (size > 10) {
            size = 10;
        }
        if (size == this.lastSize) {
            return;
        }
        this.lastSize = size;
        int treeItemHeight = this.xWorldViewer.getTree().getItemHeight();
        GridData gridData = new GridData(768);
        gridData.heightHint = treeItemHeight * (2 + size);
        tree.setLayout((Layout)ALayout.getZeroMarginLayout());
        tree.setLayoutData((Object)gridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public void loadTable() {
        try {
            if (this.xWorldViewer != null && this.xWorldViewer.getContentProvider() != null) {
                this.workItems = this.getWorkItems();
                this.xWorldViewer.setInput(this.workItems);
                this.xWorldViewer.refresh();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public Control getControl() {
        if (this.xWorldViewer == null) {
            return null;
        }
        return this.xWorldViewer.getTree();
    }

    public void dispose() {
        if (this.xWorldViewer != null) {
            this.xWorldViewer.dispose();
        }
    }

    public void refresh() {
        if (this.xWorldViewer == null || this.xWorldViewer.getTree() == null || this.xWorldViewer.getTree().isDisposed()) {
            return;
        }
        this.loadTable();
        this.setXviewerTreeSize();
        this.updateExtraInfoLabel();
        this.pointsLabel.setValueText("Put Label Here");
    }

    public WorldXViewer getxWorldViewer() {
        return this.xWorldViewer;
    }

    public Label getExtraInfoLabel() {
        return this.extraInfoLabel;
    }

    public void setExtraInfoLabel(Label extraInfoLabel) {
        this.extraInfoLabel = extraInfoLabel;
    }

    public abstract Pair<Integer, String> getExtraInfoString();

    private void updateExtraInfoLabel() {
        Pair<Integer, String> entry = this.getExtraInfoString();
        this.updateExtraInfoLabel((Integer)entry.getFirst(), (String)entry.getSecond());
    }

    private void updateExtraInfoLabel(final int color, final String infoStr) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)XMiniWorldWidget.this.extraInfoLabel)) {
                    String currentString = XMiniWorldWidget.this.extraInfoLabel.getText();
                    if (infoStr == null && currentString != null || infoStr != null && currentString == null || infoStr != null && currentString != null && !infoStr.equals(currentString)) {
                        XMiniWorldWidget.this.extraInfoLabel.setText(infoStr);
                    }
                    XMiniWorldWidget.this.extraInfoLabel.setForeground(Displays.getSystemColor((int)color));
                }
            }
        });
    }
}

