/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.logging.Level;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.core.column.AtsColumnId;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workdef.StateColorToSwtColor;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class WorldLabelProvider
extends XViewerLabelProvider {
    public WorldLabelProvider(WorldXViewer worldXViewer) {
        super((XViewer)worldXViewer);
    }

    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        try {
            for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                Image image;
                if (!item.isXColumnProvider(xCol) || (image = item.getColumnImage(element, xCol, columnIndex)) == null) continue;
                return image;
            }
            if (xCol.getId().equals(AtsColumnToken.TypeColumn.getId())) {
                return ArtifactImageManager.getImage((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact(element));
            }
            if (xCol.getId().equals(AtsColumnToken.StateColumn.getId()) && element instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)element;
                String isBlocked = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.BlockedReason, (Object)"");
                String isHold = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.HoldReason, (Object)"");
                if (Strings.isValid((String)isBlocked)) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.X_RED);
                }
                if (Strings.isValid((String)isHold)) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.HOLD);
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        try {
            for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                Color color;
                if (!item.isXColumnProvider(xCol) || (color = item.getForeground(element, xCol, columnIndex)) == null) continue;
                return color;
            }
            if (element instanceof IAtsWorkItem && xCol.getId().equals(AtsColumnId.State.getId())) {
                IAtsStateDefinition state = ((AbstractWorkflowArtifact)((Object)element)).getStateDefinition();
                if (state == null) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"State null for %s", (Object[])new Object[]{((IAtsWorkItem)element).toStringWithId()});
                } else {
                    return Displays.getSystemColor((int)StateColorToSwtColor.convert(state.getColor()));
                }
            }
            if (xCol instanceof XViewerAtsColumn) {
                return ((XViewerAtsColumn)xCol).getForeground(element, xCol, columnIndex);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    public Color getBackground(Object element, XViewerColumn xCol, int columnIndex) {
        try {
            if (xCol instanceof XViewerAtsColumn) {
                return ((XViewerAtsColumn)xCol).getBackground(element, xCol, columnIndex);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    public String getColumnText(Object element, XViewerColumn xCol, int columnIndex) {
        block4: {
            if (AtsObjects.isAtsWorkItemOrAction((Object)element)) break block4;
            return "";
        }
        try {
            for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                String text;
                if (!item.isXColumnProvider(xCol) || (text = item.getColumnText(element, xCol, columnIndex)) == null) continue;
                return text;
            }
            return "Unhandled Column";
        }
        catch (Exception ex) {
            return LogUtil.getCellExceptionString((Exception)ex);
        }
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

