/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Widget;

public class WorldContentProvider
implements ITreeContentProvider {
    protected Set<Artifact> relatedArts = new HashSet<Artifact>();
    private final WorldXViewer xViewer;

    public WorldContentProvider(WorldXViewer WorldXViewer2) {
        this.xViewer = WorldXViewer2;
    }

    public String toString() {
        return "WorldContentProvider";
    }

    public void clear(boolean forcePend) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)WorldContentProvider.this.xViewer.getControl())) {
                    WorldContentProvider.this.xViewer.setInput(Collections.emptyList());
                    WorldContentProvider.this.xViewer.refresh();
                }
            }
        }, (boolean)forcePend);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof Artifact) {
            try {
                Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(parentElement);
                if (artifact.isDeleted()) {
                    return new Object[0];
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                    this.relatedArts.addAll(org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getWorkItemService().getTeams((Object)artifact))));
                    return AtsApiService.get().getWorkItemService().getTeams((Object)artifact).toArray();
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                    List<Artifact> arts = AtsApiService.get().getGoalMembersCache().getMembers((GoalArtifact)artifact);
                    this.relatedArts.addAll(arts);
                    AtsBulkLoad.bulkLoadArtifacts(this.relatedArts);
                    return arts.toArray(new Artifact[arts.size()]);
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                    List<Artifact> arts = AtsApiService.get().getSprintItemsCache().getMembers((SprintArtifact)artifact);
                    this.relatedArts.addAll(arts);
                    AtsBulkLoad.bulkLoadArtifacts(this.relatedArts);
                    return arts.toArray(new Artifact[arts.size()]);
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                    TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)artifact;
                    ArrayList<AbstractReviewArtifact> arts = new ArrayList<AbstractReviewArtifact>();
                    arts.addAll(ReviewManager.getReviews(teamArt));
                    arts.addAll(org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt)));
                    this.relatedArts.addAll(arts);
                    return arts.toArray();
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof Artifact) {
            Artifact artifact;
            block9: {
                try {
                    artifact = AtsApiService.get().getQueryServiceIde().getArtifact(element);
                    if (!artifact.isDeleted()) break block9;
                    return null;
                }
                catch (Exception exception) {}
            }
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                return ((IAtsTeamWorkflow)artifact).getParentAction().getStoreObject();
            }
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                return ((TaskArtifact)artifact).getParentAWA();
            }
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview})) {
                return ReviewManager.cast(artifact).getParentAWA();
            }
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                return ((GoalArtifact)artifact).getParentAWA();
            }
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                return ((SprintArtifact)artifact).getParentAWA();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Collection) {
            return true;
        }
        if (element instanceof String) {
            return false;
        }
        if (AtsApiService.get().getQueryServiceIde().getArtifact(element).isDeleted()) {
            return false;
        }
        if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            return true;
        }
        if (element instanceof AbstractWorkflowArtifact) {
            try {
                return this.hasAtsWorldChildren((AbstractWorkflowArtifact)((Object)element));
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)ex.toString());
            }
        }
        return true;
    }

    private boolean hasAtsWorldChildren(AbstractWorkflowArtifact workflow) {
        if (workflow.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Task)) {
            return false;
        }
        if (workflow instanceof TeamWorkFlowArtifact && workflow.getRelatedArtifactsCount(AtsRelationTypes.TeamWfToTask_Task) > 0) {
            return true;
        }
        if (workflow instanceof TeamWorkFlowArtifact && workflow.getRelatedArtifactsCount(AtsRelationTypes.TeamWorkflowToReview_Review) > 0) {
            return true;
        }
        if (workflow instanceof GoalArtifact && workflow.getRelatedArtifactsCount(AtsRelationTypes.Goal_Member) > 0) {
            return true;
        }
        return workflow instanceof SprintArtifact && workflow.getRelatedArtifactsCount(AtsRelationTypes.AgileSprintToItem_AtsItem) > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            return new Object[]{inputElement};
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

