/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review.role;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.UserRoleError;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class UserRoleValidator {
    public static UserRoleError isValid(Artifact artifact) {
        try {
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview})) {
                PeerToPeerReviewArtifact peerToPeerReviewArtifact = (PeerToPeerReviewArtifact)artifact;
                IAtsPeerReviewRoleManager roleMgr = ((IAtsPeerToPeerReview)artifact).getRoleManager();
                UserRoleError result = roleMgr.validateRoleTypeMinimums(peerToPeerReviewArtifact.getStateDefinition(), roleMgr);
                if (!result.isOK()) {
                    return result;
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return UserRoleError.ExceptionValidatingRoles;
        }
        return UserRoleError.None;
    }
}

