/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.workflow.IAtsDatabaseTypeProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.ChangeTypeToSwtImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ChangeTypeDialog
extends ListDialog {
    ChangeType selected = null;

    public ChangeTypeDialog(Shell parent) {
        super(parent);
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider(new ChangeLabelProvider());
        this.setInput(this.getValues());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle("Select Change Type");
    }

    public ChangeType getSelection() {
        return (ChangeType)this.getResult()[0];
    }

    private ChangeType[] getValues() {
        for (IAtsDatabaseTypeProvider provider : AtsApiService.get().getDatabaseTypeProviders()) {
            if (!provider.useFactory() || provider.getChangeTypeValues() == null) continue;
            return provider.getChangeTypeValues().toArray(new ChangeType[provider.getChangeTypeValues().size()]);
        }
        return ChangeType.values();
    }

    protected Control createDialogArea(Composite container) {
        new Label(container, 0).setText("     Select Change Type:");
        Control c = super.createDialogArea(container);
        GridData gd = new GridData(1808);
        gd.heightHint = 80;
        gd.widthHint = 300;
        this.getTableViewer().getTable().setLayoutData((Object)gd);
        GridLayout layout = ALayout.getZeroMarginLayout();
        layout.marginWidth = 20;
        this.getTableViewer().getTable().getParent().setLayout((Layout)layout);
        if (this.selected != null) {
            ArrayList<ChangeType> sel = new ArrayList<ChangeType>();
            sel.add(this.selected);
            this.getTableViewer().setSelection((ISelection)new StructuredSelection(sel.toArray(new Object[sel.size()])));
            this.getTableViewer().getTable().setFocus();
        }
        return c;
    }

    protected void okPressed() {
        if (this.getTableViewer().getSelection().isEmpty()) {
            AWorkbench.popup((String)"ERROR", (String)"Must make selection.");
            return;
        }
        super.okPressed();
    }

    public void setSelected(ChangeType selected) {
        this.selected = selected;
    }

    public class ChangeLabelProvider
    implements ILabelProvider {
        public Image getImage(Object arg0) {
            ChangeType type = (ChangeType)arg0;
            return ChangeTypeToSwtImage.getImage(type);
        }

        public String getText(Object arg0) {
            ChangeType type = (ChangeType)arg0;
            return type.name();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }
}

