/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.walker.IActionWalkerItem;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;

public class TaskWrapper
implements IActionWalkerItem {
    private final TeamWorkFlowArtifact teamArt;

    public TaskWrapper(TeamWorkFlowArtifact teamArt) {
        this.teamArt = teamArt;
    }

    public String toString() {
        try {
            return String.format(String.valueOf(AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)this.teamArt).size()) + " Tasks", new Object[0]);
        }
        catch (OseeCoreException ex) {
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.teamArt == null ? 0 : this.teamArt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskWrapper other = (TaskWrapper)obj;
        return !(this.teamArt == null ? other.teamArt != null : !this.teamArt.equals((Object)other.teamArt));
    }

    @Override
    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.TASK);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void handleDoubleClick() {
        try {
            AtsEditors.openInAtsTaskEditor("Tasks", Collections.castAll(Artifact.class, (Collection)AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)this.teamArt)));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

