/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.role;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlabelMemberSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewRoleDialog
extends MessageDialog {
    private final IAtsWorkDefinition workDefinition;
    private XComboViewer roleCombo;
    private XHyperlabelMemberSelection usersLink;
    private PeerToPeerReviewArtifact reviewArt;
    private Button okButton;

    public NewRoleDialog(IAtsWorkDefinition workDefinition) {
        super(Displays.getActiveShell(), "New Role", null, "Enter New Roles", 3, new String[]{"OK", "Cancel"}, 0);
        this.workDefinition = workDefinition;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return c;
    }

    private void updateButtons() {
        if (this.roleCombo.getSelected() != null && this.usersLink != null && !this.usersLink.isEmpty()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createCustomArea(Composite parent) {
        Control customArea = super.createCustomArea(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        this.roleCombo = new XComboViewer("Select Role", 0);
        ArrayList<String> roles = new ArrayList<String>();
        for (ReviewRole role : this.workDefinition.getReviewRoles()) {
            roles.add(String.valueOf(role.getName()) + " (" + role.getReviewRoleType() + " Type)");
        }
        this.roleCombo.setInput(roles);
        this.roleCombo.createWidgets(comp, 2);
        this.roleCombo.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                NewRoleDialog.this.updateButtons();
            }
        });
        Collection atsUsers = AtsApiService.get().getUserService().getUsers(Active.Active);
        ArrayList<User> users = new ArrayList<User>();
        for (AtsUser aUser : atsUsers) {
            User user = UserManager.getUserByArtId((ArtifactId)aUser);
            if (user == null) continue;
            users.add(user);
        }
        users.remove(SystemUser.BootStrap);
        this.usersLink = new XHyperlabelMemberSelection("Select User(s)", users);
        this.usersLink.createWidgets(comp, 2);
        this.usersLink.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                NewRoleDialog.this.updateButtons();
            }
        });
        IAtsTeamDefinition teamDef = null;
        if (this.reviewArt != null && this.reviewArt.getParentTeamWorkflow() != null) {
            teamDef = this.reviewArt.getParentTeamWorkflow().getTeamDefinition();
        }
        if (teamDef == null && !this.reviewArt.getActionableItems().isEmpty()) {
            for (IAtsActionableItem ai : this.reviewArt.getActionableItems()) {
                if (ai.getTeamDefinition() == null) continue;
                teamDef = ai.getTeamDefinition();
                break;
            }
        }
        if (teamDef != null) {
            users = new ArrayList();
            for (AtsUser aUser : AtsApiService.get().getTeamDefinitionService().getMembersAndLeads(teamDef)) {
                User user = UserManager.getUserByArtId((ArtifactId)aUser);
                if (user == null) continue;
                users.add(user);
            }
            this.usersLink.setTeamMembers(users);
        }
        return customArea;
    }

    public ReviewRole getRole() {
        String roleName = (String)this.roleCombo.getSelected();
        roleName = roleName.substring(0, roleName.indexOf(" ("));
        return this.workDefinition.fromName(roleName);
    }

    public Collection<AtsUser> getUsers() {
        ArrayList<AtsUser> selected = new ArrayList<AtsUser>();
        for (User user : this.usersLink.getSelectedUsers()) {
            AtsUser aUser = AtsApiService.get().getUserService().getUserById((ArtifactId)user);
            if (aUser == null) continue;
            selected.add(aUser);
        }
        return selected;
    }

    public void setReview(PeerToPeerReviewArtifact reviewArt) {
        this.reviewArt = reviewArt;
    }
}

