/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.Active;

public class TeamDefinitionTreeContentProvider
implements ITreeContentProvider {
    private final Active active;

    public TeamDefinitionTreeContentProvider(Active active) {
        this.active = active;
    }

    public Object[] getChildren(Object parentElement) {
        List<TeamDefinition> results = new ArrayList();
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IAtsTeamDefinition && this.active != null) {
            try {
                IAtsTeamDefinition teamDef = (IAtsTeamDefinition)parentElement;
                Set children = AtsApiService.get().getTeamDefinitionService().getChildren(teamDef, false);
                List teamDefs = AtsApiService.get().getTeamDefinitionService().getActive((Collection)children, this.active);
                results = teamDefs;
            }
            catch (Exception exception) {}
        } else if (parentElement instanceof TeamDefinition && this.active != null) {
            try {
                TeamDefinition teamDef = (TeamDefinition)parentElement;
                for (Long id : teamDef.getChildren()) {
                    TeamDefinition td = (TeamDefinition)AtsApiService.get().getConfigService().getConfigurations().getIdToTeamDef().get(id);
                    if (this.active != Active.Both && (this.active != Active.Active || !td.isActive()) && (this.active != Active.InActive || td.isActive())) continue;
                    results.add(td);
                }
            }
            catch (Exception exception) {}
        }
        return results.toArray();
    }

    public Object getParent(Object element) {
        Long id;
        if (element instanceof IAtsTeamDefinition) {
            return AtsApiService.get().getTeamDefinitionService().getParentTeamDef((IAtsTeamDefinition)element);
        }
        if (element instanceof TeamDefinition && (id = ((TeamDefinition)element).getId()) > 0L) {
            TeamDefinition td = (TeamDefinition)AtsApiService.get().getConfigService().getConfigurations().getIdToTeamDef().get(id);
            return td;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TeamDefinition) {
            return !((TeamDefinition)element).getChildren().isEmpty();
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

