/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XTextDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CancelledReasonEnumDialog
extends EntryDialog {
    private String selection = "";
    private XComboDam reasonCombo;

    public CancelledReasonEnumDialog(String dialogTitle, String dialogMessage) {
        super(dialogTitle, dialogMessage);
    }

    protected Control createCustomArea(Composite parent) {
        this.customAreaParent = parent;
        this.areaComposite = new Composite(parent, 0);
        this.areaComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        this.areaComposite.setLayoutData((Object)gd);
        this.areaComposite.addMouseMoveListener(this.compListener);
        this.createErrorLabel(this.areaComposite);
        this.createExtendedArea(this.areaComposite);
        this.createTextBox();
        this.createOpenInEditorHyperlink(parent);
        this.areaComposite.layout();
        parent.layout();
        return this.areaComposite;
    }

    public String getEntry() {
        return this.selection;
    }

    private String[] getCancelledReasonValues() {
        Set valuesSet = AtsAttributeTypes.CancelledReasonEnum.getEnumStrValues();
        Object[] values = valuesSet.toArray(new String[valuesSet.size()]);
        Arrays.sort(values);
        return values;
    }

    public String getCancelledDetails() {
        return this.text.get();
    }

    public void controlEnabled() {
        this.selection = this.reasonCombo.get();
        if (this.selection.contains("Other")) {
            if (this.text.get().equals("")) {
                this.ok.setEnabled(false);
                this.text.getLabelWidget().setForeground(Displays.getSystemColor((int)3));
            } else {
                this.ok.setEnabled(true);
                this.text.getLabelWidget().setForeground(Displays.getSystemColor((int)2));
            }
        } else if (this.selection.equals("")) {
            this.ok.setEnabled(false);
        } else {
            this.ok.setEnabled(true);
        }
    }

    protected void createExtendedArea(Composite parent) {
        this.reasonCombo = new XComboDam("Cancellation Reason");
        this.reasonCombo.setFillHorizontally(true);
        this.reasonCombo.setFocus();
        this.reasonCombo.setDataStrings(this.getCancelledReasonValues());
        this.reasonCombo.createWidgets(parent, 2);
        XModifiedListener listener = new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                CancelledReasonEnumDialog.this.controlEnabled();
            }
        };
        this.reasonCombo.addXModifiedListener(listener);
    }

    protected void createTextBox() {
        this.text = new XTextDam("Cancelled Details");
        this.text.setFillHorizontally(true);
        this.text.setFocus();
        this.text.setDisplayLabel(true);
        if (this.fillVertically) {
            this.text.setFillVertically(true);
            this.text.setHeight(this.textHeight == null ? 200 : this.textHeight);
            this.text.setFont(this.getFont());
        }
        this.text.createWidgets(this.areaComposite, 2);
        this.text.setFocus();
        if (Strings.isValid((String)this.entryText)) {
            this.text.set(this.entryText);
            this.text.selectAll();
        }
        this.text.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                CancelledReasonEnumDialog.this.controlEnabled();
            }
        });
        this.addContextMenu(this.text.getStyledText());
    }
}

