/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.commit;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.commit.CommitOverride;
import org.eclipse.osee.ats.api.commit.CommitStatus;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.commit.CommitXManagerFactory;
import org.eclipse.osee.ats.ide.util.widgets.commit.XCommitManager;
import org.eclipse.osee.ats.ide.util.widgets.commit.menu.CommitOverrideAction;
import org.eclipse.osee.ats.ide.util.widgets.commit.menu.RemoveCommitOverrideAction;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.util.RebaselineInProgressHandler;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.OseeTreeReportAdapter;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class CommitXManager
extends XViewer {
    private final XCommitManager xCommitManager;
    private final AtsApi atsApi;
    private final IAtsTeamWorkflow teamWf;

    public CommitXManager(Composite parent, int style, XCommitManager xRoleViewer, IAtsTeamWorkflow teamWf, AtsApi atsApi) {
        super(parent, style, (IXViewerFactory)new CommitXManagerFactory((IOseeTreeReportProvider)new OseeTreeReportAdapter("Table Report - Commit Manager")));
        this.xCommitManager = xRoleViewer;
        this.teamWf = teamWf;
        this.atsApi = atsApi;
    }

    public void updateMenuActionsForTable() {
        MenuManager mm = this.getMenuManager();
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        if (!this.getSelectedArtifacts().isEmpty()) {
            CommitOverride override;
            Object firstSelectedArt = this.getSelectedArtifacts().iterator().next();
            BranchToken branch = null;
            CommitConfigItem configItem = null;
            if (firstSelectedArt instanceof CommitConfigItem) {
                configItem = (CommitConfigItem)firstSelectedArt;
                branch = BranchManager.getBranchToken((BranchId)AtsApiService.get().getBranchService().getBranch(configItem));
            }
            if ((override = this.atsApi.getBranchService().getCommitOverrideOps().getCommitOverride((IAtsTeamWorkflow)this.xCommitManager.getTeamArt(), (BranchId)branch)) == null) {
                mm.insertAfter("XVIEWER MENU GROUP PRE", (IAction)new CommitOverrideAction(this.teamWf, branch, this.atsApi));
            } else if (branch != null) {
                mm.insertAfter("XVIEWER MENU GROUP PRE", (IAction)new RemoveCommitOverrideAction(this.teamWf, branch, this.atsApi));
            }
        }
    }

    public void dispose() {
        this.getLabelProvider().dispose();
    }

    public List<Object> getSelectedArtifacts() {
        ArrayList<Object> arts = new ArrayList<Object>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                arts.add(item.getData());
                ++n2;
            }
        }
        return arts;
    }

    public XCommitManager getXCommitViewer() {
        return this.xCommitManager;
    }

    public void handleDoubleClick() {
        try {
            Object firstSelectedArt = this.getSelectedArtifacts().iterator().next();
            BranchId branch = null;
            String displayName = "";
            CommitConfigItem configItem = null;
            if (firstSelectedArt instanceof CommitConfigItem) {
                configItem = (CommitConfigItem)firstSelectedArt;
                branch = AtsApiService.get().getBranchService().getBranch(configItem);
                displayName = configItem.toString();
            } else if (firstSelectedArt instanceof TransactionToken) {
                TransactionToken txRecord = (TransactionToken)firstSelectedArt;
                branch = txRecord.getBranch();
                displayName = txRecord.toString();
            } else {
                throw new OseeArgumentException("Unhandled element type [%s]", new Object[]{firstSelectedArt.getClass().toString()});
            }
            CommitStatus commitStatus = AtsApiService.get().getBranchService().getCommitStatus((IAtsTeamWorkflow)this.xCommitManager.getTeamArt(), branch, configItem);
            if (commitStatus == CommitStatus.Commit_Overridden) {
                AWorkbench.popup((String)"Commit Overridden.  Right-click remove override to continue.");
            } else if (commitStatus == CommitStatus.Rebaseline_In_Progress) {
                RebaselineInProgressHandler.handleRebaselineInProgress((BranchId)this.xCommitManager.getTeamArt().getWorkingBranch());
            } else if (commitStatus == CommitStatus.Working_Branch_Not_Created) {
                AWorkbench.popup((String)commitStatus.getDisplayName(), (String)"Need to create a working branch");
            } else if (commitStatus == CommitStatus.No_Commit_Needed) {
                AWorkbench.popup((String)commitStatus.getDisplayName(), (String)"Destination Branch creation date is after commit to Parent Destination Branch; No Action Needed");
            } else if (commitStatus == CommitStatus.Branch_Not_Configured) {
                AWorkbench.popup((String)commitStatus.getDisplayName(), (String)("Talk to project lead to configure branch for version [" + displayName + "]"));
            } else if (commitStatus == CommitStatus.Branch_Commit_Disabled) {
                AWorkbench.popup((String)commitStatus.getDisplayName(), (String)("Talk to project lead as to why commit disabled for version [" + displayName + "]"));
            } else if (commitStatus == CommitStatus.Commit_Needed || commitStatus == CommitStatus.Merge_In_Progress) {
                XResultData rd = new XResultData();
                AtsApiService.get().getBranchServiceIde().commitWorkingBranch(this.xCommitManager.getTeamArt(), true, false, branch, false, rd);
                if (rd.isErrors()) {
                    ResultsEditor.open((String)"Commit Failure", (XResultData)rd);
                }
            } else if (commitStatus == CommitStatus.Committed) {
                AtsApiService.get().getBranchServiceIde().showChangeReportForBranch(this.xCommitManager.getTeamArt(), branch);
            } else if (commitStatus == CommitStatus.Committed_With_Merge) {
                this.handleCommittedWithMerge(branch);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private void handleCommittedWithMerge(BranchId branch) {
        MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), "Select Report", null, "Both Change Report and Merge Manager exist.\n\nSelect to open.", 3, new String[]{"Show Change Report", "Show Merge Manager", "Cancel"}, 0);
        int result = dialog.open();
        if (result == 2) {
            return;
        }
        if (result == 0) {
            AtsApiService.get().getBranchServiceIde().showChangeReportForBranch(this.xCommitManager.getTeamArt(), branch);
        } else {
            AtsApiService.get().getBranchServiceIde().showMergeManager(this.xCommitManager.getTeamArt());
        }
    }
}

