/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workflow.AtsAttachment;
import org.eclipse.osee.ats.api.workflow.AtsAttachments;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XAttachmentWidget;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.ws.AWorkspace;

public class XAttachmentExampleWidget
extends XAttachmentWidget {
    private static final String LABEL = "Select Peer Review Checklist to Attach";
    public static final Object WIDGET_ID = XAttachmentExampleWidget.class.getSimpleName();
    private static String PEER_REVIEW_CHECKLIST_STATIC_ID = "7244494692772089382";
    public static String ATTACHMENT_EXAMPLE_KEY = "XAttachmentExampleWidget";

    public XAttachmentExampleWidget() {
        super(LABEL, "");
    }

    @Override
    protected String getFileListString() {
        String workspacePath = AWorkspace.getWorkspacePath();
        File workspaceFile = new File(workspacePath);
        if (!workspaceFile.exists()) {
            throw new OseeStateException("Temporary checklist location [%s] does not exist", new Object[]{workspacePath});
        }
        AtsAttachments checklists = new AtsAttachments();
        for (String filename : Arrays.asList("Requirements_Checklist.xlsx", "Code_Checklist.txt", "Test_Checklist.docx")) {
            try {
                String checklistName = filename;
                checklistName = checklistName.replaceFirst("\\..*$", "");
                checklistName = checklistName.replaceFirst("_", " ");
                File file = OseeInf.getResourceAsFile((String)("demoPeerChecklists/" + filename), XAttachmentExampleWidget.class);
                String filePath = file.getAbsolutePath();
                checklists.addAttachment(new AtsAttachment(checklistName, filePath, (BranchId)BranchToken.SENTINEL));
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        String dbFileList = AtsApiService.get().getConfigValue("PeerReviewChecklist");
        if (!dbFileList.isEmpty()) {
            dbFileList = dbFileList.substring(dbFileList.indexOf(": [ {") + 1, dbFileList.length() - 3);
        }
        dbFileList = dbFileList.replace("[", ",");
        String jsonFile = JsonUtil.toJson((Object)checklists);
        int index = jsonFile.indexOf(jsonFile.charAt(jsonFile.length() - 3));
        StringBuilder sb = new StringBuilder(jsonFile);
        sb.insert(index, dbFileList);
        return sb.toString();
    }

    @Override
    public String getAttachmentStaticId() {
        return PEER_REVIEW_CHECKLIST_STATIC_ID;
    }
}

