/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.util.UserIdSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class UserCheckTreeDialog
extends FilteredCheckboxTreeDialog<AtsUser> {
    private Collection<AtsUser> teamMembers;
    private boolean includeAutoSelectButtons = false;

    public UserCheckTreeDialog(Collection<AtsUser> users) {
        this("Select Users", "Select Users", users);
    }

    public UserCheckTreeDialog() {
        this("Select Users", "Select to assign.\nDeSelect to un-assign.", AtsApiService.get().getUserService().getUsers(Active.Active));
    }

    public UserCheckTreeDialog(String title, String message, Collection<AtsUser> users) {
        super(title, message, users, (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new UserCheckTreeLabelProvider(), null);
    }

    public Collection<AtsUser> getUsersSelected() {
        return this.getChecked();
    }

    protected void createPreCustomArea(Composite parent) {
        final UserCheckTreeDialog fUld = this;
        if (this.includeAutoSelectButtons) {
            Composite comp = new Composite(parent, 0);
            Button setUnAssigned = new Button(comp, 8);
            setUnAssigned.setText("Set as Un-Assigned and Close");
            setUnAssigned.setToolTipText("Set as Un-Assigned and close Dialog");
            setUnAssigned.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    UserCheckTreeDialog.this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(Collections.emptyList()));
                    fUld.setInitialSelections(Arrays.asList(AtsCoreUsers.UNASSIGNED_USER));
                    UserCheckTreeDialog.this.okPressed();
                }
            });
            Button setAsMe = new Button(comp, 8);
            setAsMe.setText("Set as Me and Close");
            setAsMe.setToolTipText("Set as current user and close Dialog");
            setAsMe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    UserCheckTreeDialog.this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(Collections.emptyList()));
                    fUld.setInitialSelections(Arrays.asList(AtsApiService.get().getUserService().getCurrentUser()));
                    UserCheckTreeDialog.this.okPressed();
                }
            });
            Button addMe = new Button(comp, 8);
            addMe.setText("Add Me and Close");
            addMe.setToolTipText("Add Me to checked assignees and close Dialog");
            addMe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    LinkedList<AtsUser> users = new LinkedList<AtsUser>(fUld.getChecked());
                    users.add(AtsApiService.get().getUserService().getCurrentUser());
                    fUld.setInitialSelections(users);
                    UserCheckTreeDialog.this.okPressed();
                }
            });
            comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)3, (boolean)false));
            comp.setLayoutData((Object)new GridData());
        }
    }

    protected Control createDialogArea(Composite container) {
        Control c = super.createDialogArea(container);
        if (this.teamMembers != null) {
            ((UserCheckTreeLabelProvider)this.getTreeViewer().getViewer().getLabelProvider()).setTeamMembers(this.teamMembers);
        }
        this.getTreeViewer().setSorter((ViewerSorter)new UserIdSorter(this.getInitialSelections(), this.teamMembers));
        return c;
    }

    public Collection<AtsUser> getTeamMembers() {
        return this.teamMembers;
    }

    public void setTeamMembers(Collection<AtsUser> teamMembers) {
        if (this.teamMembers == null) {
            this.teamMembers = new HashSet<AtsUser>();
        }
        this.teamMembers.addAll(teamMembers);
    }

    public void setIncludeAutoSelectButtons(boolean includeAutoSelectButtons) {
        this.includeAutoSelectButtons = includeAutoSelectButtons;
    }

    public static class UserCheckTreeLabelProvider
    implements ILabelProvider {
        private Collection<AtsUser> teamMembers;

        public Image getImage(Object arg0) {
            return null;
        }

        public String getText(Object arg0) {
            if (this.teamMembers != null && this.teamMembers.contains(arg0)) {
                return String.valueOf(((AtsUser)arg0).getName()) + " (Team)";
            }
            return ((AtsUser)arg0).getName();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public void setTeamMembers(Collection<AtsUser> teamMembers) {
            this.teamMembers = teamMembers;
        }
    }
}

