/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.IDefaultInitialBranchesProvider;

public class TeamBasedDefaultBranchProvider
implements IDefaultInitialBranchesProvider {
    public Collection<BranchId> getDefaultInitialBranches() {
        AtsUser user = AtsApiService.get().getUserService().getCurrentUser();
        try {
            ArrayList<TeamDefinition> teams = new ArrayList<TeamDefinition>();
            for (ArtifactToken art : AtsApiService.get().getRelationResolver().getRelated((IAtsObject)user, AtsRelationTypes.TeamMember_Team)) {
                teams.add(AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)art));
            }
            LinkedList<BranchId> branches = new LinkedList<BranchId>();
            for (IAtsTeamDefinition iAtsTeamDefinition : teams) {
                branches.add(AtsApiService.get().getTeamDefinitionService().getTeamBranchId(iAtsTeamDefinition));
            }
            return branches;
        }
        catch (Exception ex) {
            OseeLog.log(TeamBasedDefaultBranchProvider.class, (Level)Level.WARNING, (Throwable)ex);
            return Collections.emptyList();
        }
    }
}

