/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.widget.AbstractXComboViewerSearchWidget;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelActionableItemSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelTeamDefinitionSelection;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;

public class VersionSearchWidget
extends AbstractXComboViewerSearchWidget<IAtsVersion> {
    public static final String VERSION = "Version";
    private XHyperlabelTeamDefinitionSelection teamSelection;
    private XHyperlabelActionableItemSelection ActionableSelection;

    public VersionSearchWidget(WorldEditorParameterSearchItem searchItem) {
        super(VERSION, searchItem);
    }

    @Override
    public void set(AtsSearchData data) {
        if (this.getWidget() != null) {
            Version version;
            this.setup((XWidget)this.getWidget());
            if (data.getVersionId() > 0L && (version = AtsApiService.get().getVersionService().getVersionById(ArtifactId.valueOf((Long)data.getVersionId()))) != null) {
                this.getWidget().setSelected(Arrays.asList(version));
            }
        }
    }

    public void setupActionableActs(XWidget teamCombo) {
        this.ActionableSelection = (XHyperlabelActionableItemSelection)teamCombo;
        teamCombo.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                VersionSearchWidget.this.setup((XWidget)VersionSearchWidget.this.getWidget());
            }
        });
    }

    public void setupTeamDef(XWidget teamCombo) {
        this.teamSelection = (XHyperlabelTeamDefinitionSelection)teamCombo;
        teamCombo.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                VersionSearchWidget.this.setup((XWidget)VersionSearchWidget.this.getWidget());
            }
        });
    }

    @Override
    public String getInitialText() {
        if (this.teamSelection == null || this.teamSelection.getSelectedTeamDefintions().isEmpty()) {
            return "--select team--";
        }
        return "";
    }

    private List<IAtsVersion> getSortedVersions(IAtsTeamDefinition teamDefHoldingVersions) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        versions.addAll(AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions));
        Collections.sort(versions, new Comparator<IAtsVersion>(){

            @Override
            public int compare(IAtsVersion aObj1, IAtsVersion aObj2) {
                if (!aObj1.isReleased() && aObj2.isReleased()) {
                    return -1;
                }
                if (aObj1.isReleased() && !aObj2.isReleased()) {
                    return 1;
                }
                return aObj1.getName().compareTo(aObj2.getName());
            }
        });
        return versions;
    }

    public Collection<IAtsTeamDefinition> getSelectedTeamDefinitions() {
        if (this.teamSelection == null) {
            return Collections.emptyList();
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.teamSelection.getSelectedTeamDefintions());
    }

    public Collection<IAtsActionableItem> getSelectedActionableItems() {
        if (this.ActionableSelection == null) {
            return Collections.emptyList();
        }
        return this.ActionableSelection.getSelectedActionableItems();
    }

    @Override
    public void setup(XWidget widget) {
        super.setup(widget);
        ((XComboViewer)widget).getCombo().setVisibleItemCount(25);
        widget.setToolTip("Select Team to populate Version list");
    }

    @Override
    public Collection<IAtsVersion> getInput() {
        IAtsTeamDefinition teamDefHoldingVersions;
        HashSet<IAtsVersion> versions = new HashSet<IAtsVersion>();
        Collection<IAtsActionableItem> teamActArts = this.getSelectedActionableItems();
        Collection<IAtsTeamDefinition> teamDefArts = this.getSelectedTeamDefinitions();
        if (!teamDefArts.isEmpty() && (teamDefHoldingVersions = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionHoldingVersions(teamDefArts.iterator().next())) != null) {
            versions.addAll(this.getSortedVersions(teamDefHoldingVersions));
        }
        if (!teamActArts.isEmpty()) {
            for (IAtsActionableItem ai : teamActArts) {
                for (ArtifactToken teamDefArt : AtsApiService.get().getRelationResolver().getRelated((IAtsObject)ai, AtsRelationTypes.TeamActionableItem_TeamDefinition)) {
                    TeamDefinition teamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)teamDefArt);
                    IAtsTeamDefinition teamDefHoldVer = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionHoldingVersions((IAtsTeamDefinition)teamDef);
                    versions.addAll(this.getSortedVersions(teamDefHoldVer));
                }
            }
        }
        return versions;
    }
}

