/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SavedActionSearchNavigateItem;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.search.QuickSearchDataComparator;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public final class DeleteSearchAction
extends Action {
    private final AtsSearchWorkflowSearchItem searchItem;

    public DeleteSearchAction(AtsSearchWorkflowSearchItem searchItem) {
        this.searchItem = searchItem;
    }

    public String getText() {
        return "Delete Saved Search";
    }

    public void run() {
        ArrayList searchDatas = AtsApiService.get().getQueryService().getSavedSearches(AtsApiService.get().getConfigService().getCurrentUserByLoginId(), this.searchItem.getNamespace());
        Collections.sort(searchDatas, new QuickSearchDataComparator());
        FilteredTreeDialog dialog = new FilteredTreeDialog("Delete Saved Search", "Select Search to Delete", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider());
        dialog.setInput((Object)searchDatas);
        if (dialog.open() == 0) {
            AtsSearchData selected = (AtsSearchData)dialog.getSelectedFirst();
            AtsApiService.get().getQueryService().removeSearch(AtsApiService.get().getUserService().getCurrentUser(), selected);
            SavedActionSearchNavigateItem.refreshItems();
            AWorkbench.popup((String)"Search Deleted");
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DELETE);
    }
}

