/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate.report;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.KindType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.util.HtmlExportTable;
import org.eclipse.osee.framework.ui.swt.Displays;

public class CreateActionArtifactChangeReportJob
extends Job {
    private final Set<IAtsTeamWorkflow> teamWfs;
    private final AttributeTypeToken attributeType;

    public CreateActionArtifactChangeReportJob(String jobName, Set<IAtsTeamWorkflow> teamWfs, AttributeTypeToken attributeType) {
        super(jobName);
        this.teamWfs = teamWfs;
        this.attributeType = attributeType;
    }

    public IStatus run(IProgressMonitor monitor) {
        return CreateActionArtifactChangeReportJob.runIt(monitor, this.getName(), this.teamWfs, this.attributeType);
    }

    public static IStatus runIt(IProgressMonitor monitor, String jobName, Collection<IAtsTeamWorkflow> teamWfs, AttributeTypeToken attributeType) {
        XResultData rd = new XResultData();
        try {
            if (teamWfs.isEmpty()) {
                throw new OseeStateException("No Actions/Workflows Specified", new Object[0]);
            }
            CreateActionArtifactChangeReportJob.retrieveData(monitor, teamWfs, attributeType, rd);
            if (rd.toString().equals("")) {
                rd.log("No Problems Found");
            }
            final String html = XResultDataUI.getReport((XResultData)rd, (String)jobName).getManipulatedHtml(Arrays.asList(Manipulations.NONE));
            final String title = jobName;
            Displays.pendInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Result result = new HtmlExportTable(title, html, true, false).exportCsv();
                    if (result.isFalse()) {
                        AWorkbench.popup((Result)result);
                        return;
                    }
                    AWorkbench.popup((String)title, (String)("Completed " + title + "\n\nFile saved to " + System.getProperty("user.home") + File.separator + "table.csv"));
                }
            });
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Status(4, "org.eclipse.osee.ats.ide", -1, "Failed", (Throwable)ex);
        }
    }

    private static void retrieveData(IProgressMonitor monitor, Collection<IAtsTeamWorkflow> teamWfs, AttributeTypeToken attributeType, XResultData rd) {
        monitor.subTask("Retrieving Actions");
        int x = 1;
        rd.addRaw(AHTML.beginMultiColumnTable((int)95));
        rd.addRaw(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"ID", "Bulld", "UI", attributeType.getName(), "RPCR", "Change"}));
        for (IAtsTeamWorkflow teamWf : teamWfs) {
            TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)teamWf.getStoreObject();
            String rcprId = (String)teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, "");
            String result = String.format("Processing %s/%s RPCR %s for \"%s\"", x, teamWfs.size(), rcprId, teamArt.getTeamDefinition().getName());
            monitor.subTask(result);
            rd.log("\nRPCR " + rcprId);
            for (CommitConfigItem commitConfigItem : AtsApiService.get().getBranchService().getConfigArtifactsConfiguredToCommitTo((IAtsTeamWorkflow)teamArt)) {
                CreateActionArtifactChangeReportJob.processTeam(teamArt, AtsApiService.get().getBranchService().getBranchShortName(commitConfigItem), (AttributeTypeId)attributeType, commitConfigItem, rd);
            }
            ++x;
        }
        rd.addRaw(AHTML.endMultiColumnTable());
    }

    private static void processTeam(TeamWorkFlowArtifact teamArt, String buildId, AttributeTypeId attributeType, CommitConfigItem commitConfigItem, XResultData rd) {
        List attrStrs;
        String rpcrNum = (String)teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, "");
        ChangeData changeData = AtsApiService.get().getBranchServiceIde().getChangeData(teamArt, commitConfigItem);
        for (Artifact modArt : changeData.getArtifacts(KindType.Artifact, new ModificationType[]{ModificationType.NEW, ModificationType.MODIFIED})) {
            attrStrs = modArt.getAttributesToStringList(attributeType);
            if (attrStrs.isEmpty()) {
                attrStrs.add("Unspecified");
            }
            for (String attrStr : attrStrs) {
                rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{teamArt.getAtsId(), buildId, modArt.getName(), attrStr, rpcrNum, "Content"}));
            }
        }
        for (Artifact artChg : changeData.getArtifacts(KindType.Artifact, new ModificationType[]{ModificationType.DELETED})) {
            attrStrs = artChg.getAttributesToStringList(attributeType);
            if (attrStrs.isEmpty()) {
                attrStrs.add("Unspecified");
            }
            for (String attrStr : attrStrs) {
                rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{teamArt.getAtsId(), buildId, artChg.getName(), attrStr, rpcrNum, "Deleted"}));
            }
        }
        for (Artifact artChg : changeData.getArtifacts(KindType.RelationOnly, new ModificationType[]{ModificationType.NEW, ModificationType.MODIFIED})) {
            attrStrs = artChg.getAttributesToStringList(attributeType);
            if (attrStrs.isEmpty()) {
                attrStrs.add("Unspecified");
            }
            for (String attrStr : attrStrs) {
                rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{teamArt.getAtsId(), buildId, artChg.getName(), attrStr, rpcrNum, "Relation"}));
            }
        }
    }
}

