/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfePromptChangeStatus;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;

public class StatePercentCompleteXWidget
extends XHyperlinkLabelValueSelection {
    private final AbstractWorkflowArtifact sma;
    private final StateXWidgetPage page;
    private final boolean isCurrentState;
    private final WorkflowEditor editor;
    public static final String TOOLTIP = "Calculation: \n     State Percent: amount entered by user\n     Task Percent: total percent of all tasks related to state / number of tasks related to state\n     Review Percent: total percent of all reviews related to state / number of reviews related to state\nTotal State Percent: state percent + all task percents + all review percents / 1 + num tasks + num reviews";

    public StatePercentCompleteXWidget(IManagedForm managedForm, StateXWidgetPage page, AbstractWorkflowArtifact sma, Composite composite, int horizontalSpan, XModifiedListener xModListener, boolean isCurrentState, WorkflowEditor editor) {
        super("\"" + page.getName() + "\"" + " State Percent Complete");
        this.page = page;
        this.sma = sma;
        this.isCurrentState = isCurrentState;
        this.editor = editor;
        if (xModListener != null) {
            this.addXModifiedListener(xModListener);
        }
        this.setEditable(isCurrentState && !sma.isReadOnly());
        this.setFillHorizontally(true);
        this.setToolTip(TOOLTIP);
        super.createWidgets(managedForm, composite, horizontalSpan);
    }

    public boolean handleSelection() {
        try {
            WfePromptChangeStatus.promptChangeStatus(Collections.singleton(this.sma), false);
            this.editor.onDirtied();
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public String getCurrentValue() {
        if (this.page == null) {
            return "page == null";
        }
        try {
            this.setEditable(this.isCurrentState && !this.sma.isReadOnly());
            StringBuffer sb = new StringBuffer(String.format("        State Percent: %d", this.sma.getStateMgr().getPercentComplete(this.page.getName())));
            boolean breakoutNeeded = false;
            if (this.sma instanceof TeamWorkFlowArtifact && AtsApiService.get().getTaskService().hasTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)this.sma))) {
                sb.append(String.format("\n        Task  Percent: %d", AtsApiService.get().getEarnedValueService().getPercentCompleteFromTasks((IAtsWorkItem)this.sma, (IStateToken)this.page)));
                breakoutNeeded = true;
            }
            if (this.sma.isTeamWorkflow() && AtsApiService.get().getReviewService().hasReviews((IAtsTeamWorkflow)((TeamWorkFlowArtifact)this.sma))) {
                sb.append(String.format("\n     Review Percent: %d", AtsApiService.get().getEarnedValueService().getPercentCompleteFromReviews((IAtsWorkItem)this.sma, (IStateToken)this.page)));
                breakoutNeeded = true;
            }
            if (breakoutNeeded) {
                if (!this.getControl().isDisposed()) {
                    this.setToolTip(String.valueOf(sb.toString()) + "\n" + TOOLTIP);
                }
                return String.valueOf(PercentCompleteTotalUtil.getPercentCompleteSMAStateTotal((IAtsObject)this.sma, (IStateToken)this.page, (AtsApi)AtsApiService.get()));
            }
            return String.valueOf(this.sma.getStateMgr().getPercentComplete(this.page.getName()));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }
}

