/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.history;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.HistoryLabelProvider;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.HistoryRefreshAction;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.HistoryXViewer;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class XHistoryViewer
extends GenericXWidget {
    private HistoryXViewer xViewer;
    private ToolBar toolBar;
    protected final AbstractWorkflowArtifact awa;
    protected final Collection<Change> changes = new ArrayList<Change>();

    public XHistoryViewer(AbstractWorkflowArtifact awa) {
        super("");
        this.awa = awa;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        if (this.isDisplayLabel() && !this.getLabel().equals("")) {
            this.labelWidget = new Label(parent, 0);
            this.labelWidget.setText(String.valueOf(this.getLabel()) + ":");
            if (this.getToolTip() != null) {
                this.labelWidget.setToolTipText(this.getToolTip());
            }
        }
        Composite mainComp = new Composite(parent, 2048);
        mainComp.setLayoutData((Object)new GridData(1808));
        mainComp.setLayout((Layout)ALayout.getZeroMarginLayout());
        if (this.toolkit != null) {
            this.toolkit.paintBordersFor(mainComp);
        }
        this.createToolBar(mainComp);
        HistoryRefreshAction refreshAction = new HistoryRefreshAction("Refresh History", 8, this);
        ActionContributionItem item = new ActionContributionItem((IAction)refreshAction);
        item.fill(this.toolBar, 0);
        this.xViewer = new HistoryXViewer(mainComp, 67586);
        this.xViewer.setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.xViewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider(this.xViewer));
        new ActionContributionItem((IAction)this.xViewer.getCustomizeAction()).fill(this.toolBar, -1);
        if (this.toolkit != null) {
            this.toolkit.adapt((Control)this.xViewer.getStatusLabel(), false, false);
        }
        this.refreshTableSize();
        refreshAction.run();
    }

    private void refreshTableSize() {
        Tree tree = this.xViewer.getTree();
        GridData gridData = new GridData(4, 0, true, false);
        gridData.heightHint = this.getTableHeight();
        tree.setLayout((Layout)ALayout.getZeroMarginLayout());
        tree.setLayoutData((Object)gridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    private int getTableHeight() {
        if (this.xViewer.getTree().getItemCount() > 5) {
            return this.xViewer.getTree().getItemHeight() * (this.xViewer.getTree().getItemCount() + 1);
        }
        return 100;
    }

    public ScrolledForm getForm(Composite composite) {
        ScrolledForm form = null;
        if (composite == null) {
            return null;
        }
        if (composite instanceof ScrolledForm) {
            return (ScrolledForm)composite;
        }
        if (!(composite instanceof ScrolledForm)) {
            form = this.getForm(composite.getParent());
        }
        return form;
    }

    public void createToolBar(Composite parent) {
        Composite bComp = new Composite(parent, 0);
        bComp.setLayout((Layout)new GridLayout(2, false));
        bComp.setLayoutData((Object)new GridData(768));
        Composite actionComp = new Composite(bComp, 0);
        actionComp.setLayout((Layout)new GridLayout());
        actionComp.setLayoutData((Object)new GridData(3));
        this.toolBar = new ToolBar(actionComp, 0x820000);
        GridData gd = new GridData(768);
        this.toolBar.setLayoutData((Object)gd);
    }

    public HistoryXViewer getXViewer() {
        return this.xViewer;
    }

    public Object getData() {
        return this.xViewer.getInput();
    }

    public Control getErrorMessageControl() {
        return this.labelWidget;
    }

    public void refresh() {
        this.getXViewer().refresh();
    }

    public Control getControl() {
        return this.xViewer.getTree();
    }
}

