/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.TargetedVersionColumnUI;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeTargetedVersionHeader
extends Composite {
    private static final String TARGET_VERSION = "Target Version:";
    Label valueLabel;
    Hyperlink link;
    private final IAtsTeamWorkflow teamWf;
    private final WorkflowEditor editor;

    public WfeTargetedVersionHeader(Composite parent, int style, IAtsTeamWorkflow teamWf, final WorkflowEditor editor) {
        super(parent, style);
        this.teamWf = teamWf;
        this.editor = editor;
        this.setLayoutData(new GridData());
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        editor.getToolkit().adapt((Composite)this);
        try {
            this.link = editor.getToolkit().createHyperlink((Composite)this, TARGET_VERSION, 0);
            this.link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    if (editor.isDirty()) {
                        editor.doSave(null);
                    }
                    WfeTargetedVersionHeader.this.promptChangeVersion();
                }
            });
            this.valueLabel = editor.getToolkit().createLabel((Composite)this, "Not Set");
            this.valueLabel.setLayoutData((Object)new GridData());
            this.refresh();
        }
        catch (OseeCoreException ex) {
            Label errorLabel = editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public boolean promptChangeVersion() {
        return WfeTargetedVersionHeader.promptChangeVersion(this.editor, this.teamWf);
    }

    public static boolean promptChangeVersion(IAtsTeamWorkflow teamWf) {
        WorkflowEditor editor = WorkflowEditor.getWorkflowEditor((IAtsWorkItem)teamWf);
        return WfeTargetedVersionHeader.promptChangeVersion(editor, teamWf);
    }

    public static boolean promptChangeVersion(WorkflowEditor editor, IAtsTeamWorkflow teamWf) {
        try {
            if (editor.isDirty()) {
                editor.doSave(null);
            }
            if (TargetedVersionColumnUI.getInstance().promptChangeVersion((TeamWorkFlowArtifact)teamWf, AtsApiService.get().getUserService().isAtsAdmin() ? VersionReleaseType.Both : VersionReleaseType.UnReleased, VersionLockedType.UnLocked)) {
                return true;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            String value = "Not Set";
            if (AtsApiService.get().getVersionService().hasTargetedVersion((IAtsWorkItem)this.teamWf)) {
                value = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)this.teamWf).getName();
            }
            this.valueLabel.setText(value);
            this.valueLabel.getParent().getParent().layout();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            this.valueLabel.setBackground(color);
        }
        if (Widgets.isAccessible((Widget)this.link)) {
            this.link.setBackground(color);
        }
    }
}

