/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeEditorAddSupportingArtifacts;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeEditorAddSupportingFiles;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.access.AccessControlArtifactUtil;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactTransfer;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.skynet.util.SkynetDragAndDrop;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.XResultDataDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Control;

public class WfeDragAndDrop
extends SkynetDragAndDrop {
    private final AbstractWorkflowArtifact sma;

    public WfeDragAndDrop(Control control, AbstractWorkflowArtifact sma, String viewId) {
        super(control, viewId);
        this.sma = sma;
    }

    public Artifact[] getArtifacts() {
        return new Artifact[]{this.sma};
    }

    public void performDragOver(DropTargetEvent event) {
        event.feedback = 25;
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 1;
        } else if (this.isValidForArtifactDrop(event)) {
            event.detail = 1;
        }
    }

    private boolean isValidForArtifactDrop(DropTargetEvent event) {
        boolean valid = false;
        if (ArtifactTransfer.getInstance().isSupportedType(event.currentDataType)) {
            AbstractWorkflowArtifact dropTarget = this.sma;
            ArtifactData toBeDropped = ArtifactTransfer.getInstance().nativeToJava(event.currentDataType);
            if (dropTarget != null) {
                LinkedList<Artifact> artsOnSameBranchAsDestination;
                block11: {
                    block10: {
                        Artifact[] artifactsBeingDropped = toBeDropped.getArtifacts();
                        artsOnSameBranchAsDestination = new LinkedList<Artifact>();
                        BranchToken destinationBranch = dropTarget.getBranch();
                        boolean onSameBranch = true;
                        Artifact[] artifactArray = artifactsBeingDropped;
                        int n = artifactsBeingDropped.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Artifact art = artifactArray[n2];
                            if (!art.isOnBranch((BranchId)destinationBranch)) {
                                onSameBranch = false;
                                break;
                            }
                            artsOnSameBranchAsDestination.add(art);
                            ++n2;
                        }
                        if (onSameBranch) break block10;
                        AWorkbench.popup((String)"Related Artifact(s) must be on the same branch.\n\nAborting Drop.");
                        return false;
                    }
                    if (!artsOnSameBranchAsDestination.isEmpty()) break block11;
                    AWorkbench.popup((String)"No Artifact(s) to relate.\n\nAborting Drop.");
                    return false;
                }
                try {
                    XResultData rd = AtsApiService.get().getAccessControlService().hasRelationTypePermission((ArtifactToken)dropTarget, (RelationTypeToken)CoreRelationTypes.SupportingInfo_SupportingInfo, artsOnSameBranchAsDestination, PermissionEnum.WRITE, AccessControlArtifactUtil.getXResultAccessHeader((String)"Relating Artifacts to Workflow", artsOnSameBranchAsDestination));
                    if (rd.isErrors()) {
                        XResultDataDialog.open((XResultData)rd, (String)"Relate Artifact(s) to Workflow", (String)"Invalid Access for Relation.\n\nAborting Drop.", (Object[])new Object[0]);
                        valid = false;
                    } else {
                        valid = true;
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        }
        return valid;
    }

    public void performDrop(DropTargetEvent event) {
        if (ArtifactTransfer.getInstance().isSupportedType(event.currentDataType)) {
            ArtifactData artData = ArtifactTransfer.getInstance().nativeToJava(event.currentDataType);
            LinkedList<Artifact> artifactsToBeRelated = new LinkedList<Artifact>();
            Artifact[] artifactArray = artData.getArtifacts();
            int n = artifactArray.length;
            int n2 = 0;
            while (n2 < n) {
                Artifact artifact = artifactArray[n2];
                artifactsToBeRelated.add(artifact);
                ++n2;
            }
            Jobs.startJob((Job)new WfeEditorAddSupportingArtifacts(this.sma, artifactsToBeRelated), (boolean)false);
        } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            try {
                Object object = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                if (object instanceof String[]) {
                    String[] items = (String[])object;
                    LinkedList<File> files = new LinkedList<File>();
                    String[] stringArray = items;
                    int n = items.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String item = stringArray[n3];
                        files.add(new File(item));
                        ++n3;
                    }
                    Jobs.startJob((Job)new WfeEditorAddSupportingFiles(this.sma, files, null), (boolean)false);
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(((Object)((Object)this)).getClass(), (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }
}

