/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.config.AbstractAtsConfig2Data;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class AtsConfig2Operation
extends AbstractOperation {
    private final AbstractAtsConfig2Data data;

    public AtsConfig2Operation(AbstractAtsConfig2Data data) {
        super("Configure Ats for " + data.getConfigName(), "org.eclipse.osee.ats.ide");
        this.data = data;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.data.validate();
        this.data.getResultData().log(String.valueOf(this.getName()) + "\n");
        monitor.worked(this.calculateWork(0.2));
        try {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getName());
            this.data.performPostConfig(changes, this.data);
            if (this.data.getResultData().isErrors()) {
                String errorStr = "Errors found, not persisting.  May need to restart your OSEE";
                this.data.getResultData().log(errorStr);
                AWorkbench.popup((String)errorStr);
            } else {
                changes.execute();
            }
        }
        catch (Exception ex) {
            this.data.getResultData().error("Exception " + ex.getLocalizedMessage());
        }
        XResultDataUI.report((XResultData)this.data.getResultData(), (String)this.getName());
        monitor.worked(this.calculateWork(0.1));
    }
}

