/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Date;
import java.util.HashSet;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public abstract class AbstractWorkflowVersionDateColumn
extends XViewerAtsAttributeValueColumn {
    public AbstractWorkflowVersionDateColumn(String id, AttributeTypeToken attributeType) {
        super(attributeType, id, attributeType.getUnqualifiedName(), 80, XViewerAlign.Left, false, SortDataType.Date, true, "");
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                HashSet<String> strs = new HashSet<String>();
                for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(element)) {
                    String str = this.getColumnText(team, column, columnIndex);
                    if (!Strings.isValid((String)str)) continue;
                    strs.add(str);
                }
                return Collections.toString((String)";", strs);
            }
            if (element instanceof AbstractWorkflowArtifact) {
                return AbstractWorkflowVersionDateColumn.getDateStr((AttributeTypeId)this.getAttributeType(), (AbstractWorkflowArtifact)((Object)element));
            }
            if (element instanceof IAtsWorkItem) {
                return this.getColumnText(((IAtsWorkItem)element).getStoreObject(), column, columnIndex);
            }
        }
        catch (Exception ex) {
            return LogUtil.getCellExceptionString((Exception)ex);
        }
        return super.getColumnText(element, column, columnIndex);
    }

    public static Date getDateFromWorkflow(AttributeTypeId attributeType, Object object) {
        TeamWorkFlowArtifact teamArt;
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
            return (Date)((TeamWorkFlowArtifact)((Object)object)).getSoleAttributeValue(attributeType, null);
        }
        if (object instanceof AbstractWorkflowArtifact && (teamArt = (TeamWorkFlowArtifact)((AbstractWorkflowArtifact)((Object)object)).getParentTeamWorkflow().getStoreObject()) != null) {
            return AbstractWorkflowVersionDateColumn.getDateFromWorkflow(attributeType, (Object)teamArt);
        }
        return null;
    }

    public static Date getDateFromTargetedVersion(AttributeTypeId attributeType, Object object) {
        TeamWorkFlowArtifact teamArt;
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
            TeamWorkFlowArtifact teamArt2 = (TeamWorkFlowArtifact)((Object)object);
            IAtsVersion verArt = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)teamArt2);
            if (verArt != null) {
                if (attributeType == AtsAttributeTypes.ReleaseDate) {
                    return AtsApiService.get().getVersionService().getReleaseDate(verArt);
                }
                if (attributeType == AtsAttributeTypes.EstimatedReleaseDate) {
                    return AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt);
                }
            }
        } else if (object instanceof AbstractWorkflowArtifact && (teamArt = (TeamWorkFlowArtifact)((AbstractWorkflowArtifact)((Object)object)).getParentTeamWorkflow()) != null) {
            return AbstractWorkflowVersionDateColumn.getDateFromTargetedVersion(attributeType, (Object)teamArt);
        }
        return null;
    }

    public static String getDateStrFromWorkflow(AttributeTypeId attributeType, AbstractWorkflowArtifact artifact) {
        return DateUtil.getMMDDYY((Date)AbstractWorkflowVersionDateColumn.getDateFromWorkflow(attributeType, (Object)artifact));
    }

    public static String getDateStrFromTargetedVersion(AttributeTypeId attributeType, AbstractWorkflowArtifact artifact) {
        return DateUtil.getMMDDYY((Date)AbstractWorkflowVersionDateColumn.getDateFromTargetedVersion(attributeType, (Object)artifact));
    }

    public static String getDateStr(AttributeTypeId attributeType, AbstractWorkflowArtifact artifact) {
        String workflowDate = AbstractWorkflowVersionDateColumn.getDateStrFromWorkflow(attributeType, artifact);
        String versionDate = AbstractWorkflowVersionDateColumn.getDateStrFromTargetedVersion(attributeType, artifact);
        if (Strings.isValid((String)workflowDate) && Strings.isValid((String)versionDate)) {
            return String.format("%s; [%s - %s]", workflowDate, AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)artifact), versionDate);
        }
        if (Strings.isValid((String)workflowDate)) {
            return workflowDate;
        }
        if (Strings.isValid((String)versionDate)) {
            return versionDate;
        }
        return "";
    }
}

