/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.AgileReportType;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.html.ResultsEditorHtmlTab;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabel;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class XOpenStoredSprintReportsButton
extends XButton
implements ArtifactWidget {
    protected IAgileSprint sprint;
    private final boolean editable = false;
    public static final String WIDGET_ID = XOpenStoredSprintReportsButton.class.getSimpleName();
    XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            try {
                XOpenStoredSprintReportsButton.this.openInternally();
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    };

    public XOpenStoredSprintReportsButton() {
        super("Open Snapshots of Stored Sprint Charts");
        this.setImage(ImageManager.getImage((OseeImage)AtsImage.REPORT));
        this.setToolTip("Click to run Open Reports");
        this.addXModifiedListener(this.listener);
    }

    public Artifact getArtifact() {
        return AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        XHyperlinkLabel external = new XHyperlinkLabel("Open Externally");
        external.setAddDefaultListener(false);
        external.createWidgets(this.comp, horizontalSpan);
        external.getControl().setForeground(Displays.getSystemColor((int)9));
        external.getControl().addListener(4, new Listener(){

            public void handleEvent(Event event) {
                XOpenStoredSprintReportsButton.this.openExternally();
            }
        });
    }

    public void openExternally() {
        boolean found = false;
        AgileReportType[] agileReportTypeArray = AgileReportType.values();
        int n = agileReportTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AgileReportType rpt = agileReportTypeArray[n2];
            ArtifactToken rptArt = AtsApiService.get().getRelationResolver().getChildNamedOrNull((IAtsObject)this.sprint, rpt.name());
            if (rptArt != null) {
                found = true;
                RendererManager.open((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)rptArt), (PresentationType)PresentationType.PREVIEW);
            }
            ++n2;
        }
        if (!found) {
            AWorkbench.popup((String)"No Stored Reports Found");
        }
    }

    public void openInternally() {
        final LinkedList<ResultsEditorHtmlTab> tabs = new LinkedList<ResultsEditorHtmlTab>();
        AgileReportType[] agileReportTypeArray = AgileReportType.values();
        int n = agileReportTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String html;
            AgileReportType rpt = agileReportTypeArray[n2];
            ArtifactToken rptArt = AtsApiService.get().getRelationResolver().getChildNamedOrNull((IAtsObject)this.sprint, rpt.name());
            if (rptArt != null && Strings.isValid((String)(html = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((ArtifactId)rptArt, (AttributeTypeToken)CoreAttributeTypes.NativeContent, null)))) {
                tabs.add(new ResultsEditorHtmlTab(rpt.name(), rpt.name(), AHTML.simplePage((String)html)));
            }
            ++n2;
        }
        if (!tabs.isEmpty()) {
            AWorkbench.popup((String)"No Stored Reports Found");
        } else {
            ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){

                public String getEditorName() {
                    return "Stored Sprint Charts - " + XOpenStoredSprintReportsButton.this.sprint.getName();
                }

                public List<IResultsEditorTab> getResultsEditorTabs() {
                    return tabs;
                }
            });
        }
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
            this.sprint = (IAgileSprint)artifact;
        }
    }

    public boolean isEditable() {
        return false;
    }
}

