/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.agile.XOpenSprintBurndownButton;
import org.eclipse.osee.ats.ide.agile.XOpenSprintBurnupButton;
import org.eclipse.osee.ats.ide.agile.XOpenSprintDataTableButton;
import org.eclipse.osee.ats.ide.agile.XOpenSprintSummaryButton;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabel;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class XOpenSprintReportsButton
extends XButton
implements ArtifactWidget {
    protected IAgileSprint sprint;
    private final boolean editable = false;
    public static final String WIDGET_ID = XOpenSprintReportsButton.class.getSimpleName();
    XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            try {
                XOpenSprintReportsButton.this.openInternally();
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    };

    public XOpenSprintReportsButton() {
        super("Open Current Sprint Reports");
        this.setImage(ImageManager.getImage((OseeImage)AtsImage.REPORT));
        this.setToolTip("Click to run Open Reports");
        this.addXModifiedListener(this.listener);
    }

    public Artifact getArtifact() {
        return AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        XHyperlinkLabel external = new XHyperlinkLabel("Open Externally");
        external.setAddDefaultListener(false);
        external.createWidgets(this.comp, horizontalSpan);
        external.getControl().setForeground(Displays.getSystemColor((int)9));
        external.getControl().addListener(4, new Listener(){

            public void handleEvent(Event event) {
                XOpenSprintReportsButton.this.openExternally();
            }
        });
    }

    public void openExternally() {
        XOpenSprintBurndownButton down = new XOpenSprintBurndownButton();
        down.setArtifact(this.getArtifact());
        down.openExternally();
        XOpenSprintBurnupButton up = new XOpenSprintBurnupButton();
        up.setArtifact(this.getArtifact());
        up.openExternally();
        XOpenSprintSummaryButton sum = new XOpenSprintSummaryButton();
        sum.setArtifact(this.getArtifact());
        sum.openExternally();
        XOpenSprintDataTableButton data = new XOpenSprintDataTableButton();
        data.setArtifact(this.getArtifact());
        data.openExternally();
    }

    public void openInternally() {
        XOpenSprintBurndownButton down = new XOpenSprintBurndownButton();
        down.setArtifact(this.getArtifact());
        down.openInternally();
        XOpenSprintBurnupButton up = new XOpenSprintBurnupButton();
        up.setArtifact(this.getArtifact());
        up.openInternally();
        XOpenSprintSummaryButton sum = new XOpenSprintSummaryButton();
        sum.setArtifact(this.getArtifact());
        sum.openInternally();
        XOpenSprintDataTableButton data = new XOpenSprintDataTableButton();
        data.setArtifact(this.getArtifact());
        data.openInternally();
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
            this.sprint = (IAgileSprint)artifact;
        }
    }

    public boolean isEditable() {
        return false;
    }
}

