/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.SubscribeManager;
import org.eclipse.osee.ats.ide.util.SubscribeManagerUI;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class SubscribedAction
extends AbstractAtsAction {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private boolean prompt = true;

    public SubscribedAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.updateEnablement();
    }

    public void updateEnablement() {
        String title = "Subscribed";
        try {
            this.setEnabled(this.getSelectedSubscribableArts().size() > 0);
            title = this.getSelectedSubscribableArts().size() == 1 ? (SubscribeManager.amISubscribed(this.getSelectedSubscribableArts().iterator().next()) ? "Remove Subscribed" : "Add as Subscribed") : "Toggle Subscribed";
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            this.setEnabled(false);
        }
        this.setText(title);
        this.setToolTipText(title);
    }

    public Collection<AbstractWorkflowArtifact> getSelectedSubscribableArts() {
        ArrayList<AbstractWorkflowArtifact> favoritableArts = new ArrayList<AbstractWorkflowArtifact>();
        for (Artifact art : this.selectedAtsArtifacts.getSelectedWorkflowArtifacts()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            favoritableArts.add((AbstractWorkflowArtifact)art);
        }
        return favoritableArts;
    }

    @Override
    public void runWithException() {
        new SubscribeManagerUI(this.getSelectedSubscribableArts()).toggleSubscribe(this.prompt);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.SUBSCRIBED);
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }
}

