/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.plugin.xnavigate.INavigateItemRefresher;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateMenuItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public abstract class XNavigateItem {
    public static final XNavItemCat TOP_ADMIN = new XNavItemCat("Admin");
    public static final XNavItemCat REPORTS = new XNavItemCat("Reports");
    public static final XNavItemCat EMAIL_NOTIFICATIONS = new XNavItemCat("Email & Notifications");
    public static final XNavItemCat DEMO = new XNavItemCat("Demo");
    public static final XNavItemCat UTILITY = new XNavItemCat("Util");
    public static final XNavItemCat UTILITY_EXAMPLES = new XNavItemCat("Util.Examples");
    public static final XNavItemCat ADVANCED_SEARCHES = new XNavItemCat("Advanced Searches");
    public static final XNavItemCat USER_MANAGEMENT = new XNavItemCat("User Management");
    public static final XNavItemCat USER_MANAGEMENT_ADMIN = new XNavItemCat("User Management.Admin");
    public static final XNavItemCat TRACE = new XNavItemCat("Traceability");
    public static final XNavItemCat DEFINE = new XNavItemCat("Define");
    public static final XNavItemCat DEFINE_HEALTH = new XNavItemCat("Define.Health");
    public static final XNavItemCat DEFINE_ADMIN = new XNavItemCat("Define.Admin");
    public static final XNavItemCat OTE = new XNavItemCat("OTE");
    public static final XNavItemCat PLE = new XNavItemCat("PLE");
    private final List<XNavigateItem> children = new ArrayList<XNavigateItem>();
    private String name;
    private XNavigateItem parent;
    protected KeyedImage oseeImage;
    private List<IXNavigateMenuItem> menuItems;
    private Object data;
    private long id = 0L;
    protected INavigateItemRefresher refresher;
    protected final Collection<XNavItemCat> categories;
    Image image;

    public XNavigateItem(String name, OseeImage oseeImage, XNavItemCat ... xNavItemCat) {
        this(name, ImageManager.create((OseeImage)oseeImage), xNavItemCat);
    }

    public XNavigateItem(String name, KeyedImage oseeImage, XNavItemCat ... xNavItemCat) {
        this.name = name;
        this.oseeImage = oseeImage;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.categories = Collections.asHashSet((Object[])xNavItemCat);
    }

    public abstract Collection<IUserGroupArtifactToken> getUserGroups();

    public void addChild(XNavigateItem item) {
        this.children.add(item);
        item.setParent(this);
    }

    public void removeChild(XNavigateItem item) {
        this.children.remove(item);
        item.setParent(null);
    }

    public List<XNavigateItem> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public XNavigateItem getParent() {
        return this.parent;
    }

    public String getDescription() {
        return "";
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        if (this.image == null && this.oseeImage != null) {
            this.image = ImageManager.getImage((KeyedImage)this.oseeImage);
        }
        return this.image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public String toString() {
        return String.format("[%s] cats %s", this.getName(), this.categories);
    }

    public List<IXNavigateMenuItem> getMenuItems() {
        if (this.menuItems == null) {
            return java.util.Collections.emptyList();
        }
        return this.menuItems;
    }

    public void addMenuItem(IXNavigateMenuItem listener) {
        if (this.menuItems == null) {
            this.menuItems = new LinkedList<IXNavigateMenuItem>();
        }
        this.menuItems.add(listener);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void refresh() {
    }

    public void setRefresher(INavigateItemRefresher refresher) {
        this.refresher = refresher;
    }

    public void setParent(XNavigateItem parent) {
        this.parent = parent;
    }

    public Collection<XNavItemCat> getCategories() {
        return this.categories;
    }
}

