/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.util.logging.Level;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public abstract class CommandHandler
extends AbstractHandler {
    public boolean isEnabled() {
        boolean result = false;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (PlatformUI.isWorkbenchRunning() && !workbench.isStarting() && !workbench.isClosing()) {
            try {
                IStructuredSelection selection = CommandHandler.getCurrentSelection();
                if (selection != null) {
                    result = this.isEnabledWithException(selection);
                }
            }
            catch (Exception ex) {
                OseeLog.log(UiPluginConstants.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return result;
    }

    protected abstract boolean isEnabledWithException(IStructuredSelection var1);

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IStructuredSelection selection = CommandHandler.getCurrentSelection();
            Object result = null;
            if (selection != null) {
                result = this.executeWithException(event, selection);
            }
            return result;
        }
        catch (Exception ex) {
            throw new ExecutionException("Error executing command handler: ", (Throwable)ex);
        }
    }

    protected abstract Object executeWithException(ExecutionEvent var1, IStructuredSelection var2);

    protected static ISelectionProvider getSelectionProvider() {
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        ISelectionProvider selectionProvider = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (!workbench.isStarting() && !workbench.isClosing() && (page = AWorkbench.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null) {
            selectionProvider = site.getSelectionProvider();
        }
        return selectionProvider;
    }

    protected static IStructuredSelection getCurrentSelection() throws Exception {
        ISelection selection;
        IStructuredSelection structuredSelection = null;
        ISelectionProvider selectionProvider = CommandHandler.getSelectionProvider();
        if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        }
        return structuredSelection;
    }
}

