/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.parser;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ote.define.parser.IDataListener;

public abstract class BaseOutfileParser {
    private final Set<IDataListener> listeners = new HashSet<IDataListener>();

    public void registerListener(IDataListener listener) {
        this.listeners.add(listener);
    }

    public void deregisterListener(IDataListener listener) {
        this.listeners.remove(listener);
    }

    protected Set<IDataListener> getDataListeners() {
        return this.listeners;
    }

    protected void notifyOnDataEvent(String name, String value) {
        for (IDataListener listener : this.listeners) {
            listener.notifyDataEvent(name, value);
        }
    }

    public final void execute(IProgressMonitor monitor, URL fileToParse) throws Exception {
        long time = System.currentTimeMillis();
        String file = new File(fileToParse.toURI()).getName();
        monitor.subTask(String.format("Parsing: [%s]", file));
        InputStream inputStream = null;
        try {
            inputStream = fileToParse.openStream();
            this.doParse(monitor, file, inputStream);
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable2) {
                long elapsedTime = System.currentTimeMillis() - time;
                monitor.subTask(String.format("Parsed: [%s] in [%d] ms", file, elapsedTime));
                throw throwable2;
            }
            long elapsedTime = System.currentTimeMillis() - time;
            monitor.subTask(String.format("Parsed: [%s] in [%d] ms", file, elapsedTime));
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            long elapsedTime = System.currentTimeMillis() - time;
            monitor.subTask(String.format("Parsed: [%s] in [%d] ms", file, elapsedTime));
            throw throwable;
        }
        long elapsedTime = System.currentTimeMillis() - time;
        monitor.subTask(String.format("Parsed: [%s] in [%d] ms", file, elapsedTime));
    }

    public abstract boolean isValidParser(URL var1);

    protected abstract void doParse(IProgressMonitor var1, String var2, InputStream var3) throws Exception;
}

