/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.jobs;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.define.operations.LinkTestRunToTestScriptOperation;
import org.eclipse.osee.ote.define.operations.OutfileToArtifactOperation;

public class OutfileToArtifactJob
extends Job {
    private static final String JOB_NAME = "Convert Outfile to Artifact";
    private final URI[] filesToImport;
    private Artifact[] results;
    private URI[] filesWithErrors;
    private final BranchToken branch;

    public OutfileToArtifactJob(BranchToken branch, URI ... filesToImport) {
        super(JOB_NAME);
        this.setUser(true);
        this.setPriority(30);
        this.branch = branch;
        this.filesToImport = filesToImport;
        this.results = new Artifact[0];
        this.filesWithErrors = new URI[0];
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus toReturn = Status.OK_STATUS;
        try {
            try {
                monitor.beginTask(this.getName(), this.filesToImport.length * 2);
                OutfileToArtifactOperation outfileToArtifactOperation = new OutfileToArtifactOperation(this.branch, this.filesToImport);
                outfileToArtifactOperation.execute(monitor);
                this.results = outfileToArtifactOperation.getResults();
                this.filesWithErrors = outfileToArtifactOperation.getUnparseableFiles();
                if (!monitor.isCanceled()) {
                    LinkTestRunToTestScriptOperation linkingOperation = new LinkTestRunToTestScriptOperation(this.results);
                    linkingOperation.execute(monitor);
                }
            }
            catch (Exception ex) {
                toReturn = new Status(4, "org.eclipse.osee.ote.define", -1, ex.getMessage(), (Throwable)ex);
                monitor.subTask("Done");
                monitor.done();
            }
        }
        finally {
            monitor.subTask("Done");
            monitor.done();
        }
        return toReturn;
    }

    public Artifact[] getResults() {
        return this.results;
    }

    public URI[] getUnparseableFiles() {
        return this.filesWithErrors;
    }
}

